/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Signature;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with a document signature collection. This response is returned by the Service when handling any \"https://api.aspose.cloud/v4.0/words/Test.doc/signatures\" REST API requests.")
public class SignatureCollectionResponse
extends WordsResponse {
    @SerializedName(value="IsValid")
    protected Boolean isValid = null;
    @SerializedName(value="Signatures")
    protected List<Signature> signatures = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether all signatures are valid. Returns true if there is no signatures.")
    public Boolean getIsValid() {
        return this.isValid;
    }

    public SignatureCollectionResponse isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    @ApiModelProperty(value="Gets or sets signatures.")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public SignatureCollectionResponse signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public SignatureCollectionResponse addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.isValid == null) {
            throw new ApiException(400, "Property IsValid in SignatureCollectionResponse is required.");
        }
        if (this.signatures != null) {
            for (ModelIfc modelIfc : this.signatures) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureCollectionResponse signatureCollectionResponse = (SignatureCollectionResponse)o;
        return Objects.equals(this.isValid, signatureCollectionResponse.isValid) && Objects.equals(this.signatures, signatureCollectionResponse.signatures) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isValid, this.signatures, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignatureCollectionResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.getIsValid())).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.getSignatures())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

