/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.Position;
import com.aspose.words.cloud.model.StructuredDocumentTagBase;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a StructuredDocumentTag.")
public class StructuredDocumentTagInsert
extends StructuredDocumentTagBase {
    @SerializedName(value="Level")
    protected LevelEnum level = null;
    @SerializedName(value="SdtType")
    protected SdtTypeEnum sdtType = null;
    @SerializedName(value="Position")
    protected Position position = null;

    @ApiModelProperty(value="Gets or sets the level at which this SDT occurs in the document tree.")
    public LevelEnum getLevel() {
        return this.level;
    }

    public StructuredDocumentTagInsert level(LevelEnum level) {
        this.level = level;
        return this;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    @ApiModelProperty(value="Gets or sets type of this Structured document tag.")
    public SdtTypeEnum getSdtType() {
        return this.sdtType;
    }

    public StructuredDocumentTagInsert sdtType(SdtTypeEnum sdtType) {
        this.sdtType = sdtType;
        return this;
    }

    public void setSdtType(SdtTypeEnum sdtType) {
        this.sdtType = sdtType;
    }

    @ApiModelProperty(value="Gets or sets the position of the node that will be used to determine the placement of a new node.")
    public Position getPosition() {
        return this.position;
    }

    public StructuredDocumentTagInsert position(Position position) {
        this.position = position;
        return this;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.level == null) {
            throw new ApiException(400, "Property Level in StructuredDocumentTagInsert is required.");
        }
        if (this.sdtType == null) {
            throw new ApiException(400, "Property SdtType in StructuredDocumentTagInsert is required.");
        }
        if (this.position != null) {
            this.position.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredDocumentTagInsert structuredDocumentTagInsert = (StructuredDocumentTagInsert)o;
        return Objects.equals((Object)this.level, (Object)structuredDocumentTagInsert.level) && Objects.equals((Object)this.sdtType, (Object)structuredDocumentTagInsert.sdtType) && Objects.equals(this.position, structuredDocumentTagInsert.position) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.sdtType, this.position, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StructuredDocumentTagInsert {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    listItems: ").append(this.toIndentedString(this.getListItems())).append("\n");
        sb.append("    checked: ").append(this.toIndentedString(this.getChecked())).append("\n");
        sb.append("    appearance: ").append(this.toIndentedString((Object)this.getAppearance())).append("\n");
        sb.append("    dateDisplayLocale: ").append(this.toIndentedString(this.getDateDisplayLocale())).append("\n");
        sb.append("    dateDisplayFormat: ").append(this.toIndentedString(this.getDateDisplayFormat())).append("\n");
        sb.append("    fullDate: ").append(this.toIndentedString(this.getFullDate())).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.getTitle())).append("\n");
        sb.append("    dateStorageFormat: ").append(this.toIndentedString((Object)this.getDateStorageFormat())).append("\n");
        sb.append("    buildingBlockGallery: ").append(this.toIndentedString(this.getBuildingBlockGallery())).append("\n");
        sb.append("    buildingBlockCategory: ").append(this.toIndentedString(this.getBuildingBlockCategory())).append("\n");
        sb.append("    multiline: ").append(this.toIndentedString(this.getMultiline())).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.getColor())).append("\n");
        sb.append("    styleName: ").append(this.toIndentedString(this.getStyleName())).append("\n");
        sb.append("    calendarType: ").append(this.toIndentedString((Object)this.getCalendarType())).append("\n");
        sb.append("    isTemporary: ").append(this.toIndentedString(this.getIsTemporary())).append("\n");
        sb.append("    placeholderName: ").append(this.toIndentedString(this.getPlaceholderName())).append("\n");
        sb.append("    lockContentControl: ").append(this.toIndentedString(this.getLockContentControl())).append("\n");
        sb.append("    lockContents: ").append(this.toIndentedString(this.getLockContents())).append("\n");
        sb.append("    isShowingPlaceholderText: ").append(this.toIndentedString(this.getIsShowingPlaceholderText())).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.getTag())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.getId())).append("\n");
        sb.append("    wordOpenXML: ").append(this.toIndentedString(this.getWordOpenXML())).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.getLevel())).append("\n");
        sb.append("    sdtType: ").append(this.toIndentedString((Object)this.getSdtType())).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LevelEnum {
        UNKNOWN("Unknown"),
        INLINE("Inline"),
        BLOCK("Block"),
        ROW("Row"),
        CELL("Cell");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LevelEnum fromValue(String text) {
            for (LevelEnum b : LevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LevelEnum> {
            public void write(JsonWriter jsonWriter, LevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LevelEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SdtTypeEnum {
        NONE("None"),
        BIBLIOGRAPHY("Bibliography"),
        CITATION("Citation"),
        EQUATION("Equation"),
        DROPDOWNLIST("DropDownList"),
        COMBOBOX("ComboBox"),
        DATE("Date"),
        BUILDINGBLOCKGALLERY("BuildingBlockGallery"),
        DOCPARTOBJ("DocPartObj"),
        GROUP("Group"),
        PICTURE("Picture"),
        RICHTEXT("RichText"),
        PLAINTEXT("PlainText"),
        CHECKBOX("Checkbox"),
        REPEATINGSECTION("RepeatingSection"),
        REPEATINGSECTIONITEM("RepeatingSectionItem"),
        ENTITYPICKER("EntityPicker");

        private String value;

        private SdtTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SdtTypeEnum fromValue(String text) {
            for (SdtTypeEnum b : SdtTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SdtTypeEnum> {
            public void write(JsonWriter jsonWriter, SdtTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SdtTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SdtTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

