/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a table element.")
public class TableInsert
implements ModelIfc {
    @SerializedName(value="ColumnsCount")
    protected Integer columnsCount = null;
    @SerializedName(value="Position")
    protected Position position = null;
    @SerializedName(value="RowsCount")
    protected Integer rowsCount = null;

    @ApiModelProperty(value="Gets or sets the number of columns. The default value is 2.")
    public Integer getColumnsCount() {
        return this.columnsCount;
    }

    public TableInsert columnsCount(Integer columnsCount) {
        this.columnsCount = columnsCount;
        return this;
    }

    public void setColumnsCount(Integer columnsCount) {
        this.columnsCount = columnsCount;
    }

    @ApiModelProperty(value="Gets or sets the position to insert the table. The table will be inserted using the specified position.")
    public Position getPosition() {
        return this.position;
    }

    public TableInsert position(Position position) {
        this.position = position;
        return this;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @ApiModelProperty(value="Gets or sets the number of rows. The default value is 2.")
    public Integer getRowsCount() {
        return this.rowsCount;
    }

    public TableInsert rowsCount(Integer rowsCount) {
        this.rowsCount = rowsCount;
        return this;
    }

    public void setRowsCount(Integer rowsCount) {
        this.rowsCount = rowsCount;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.columnsCount == null) {
            throw new ApiException(400, "Property ColumnsCount in TableInsert is required.");
        }
        if (this.rowsCount == null) {
            throw new ApiException(400, "Property RowsCount in TableInsert is required.");
        }
        if (this.position != null) {
            this.position.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInsert tableInsert = (TableInsert)o;
        return Objects.equals(this.columnsCount, tableInsert.columnsCount) && Objects.equals(this.position, tableInsert.position) && Objects.equals(this.rowsCount, tableInsert.rowsCount);
    }

    public int hashCode() {
        return Objects.hash(this.columnsCount, this.position, this.rowsCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableInsert {\n");
        sb.append("    columnsCount: ").append(this.toIndentedString(this.getColumnsCount())).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("    rowsCount: ").append(this.toIndentedString(this.getRowsCount())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

