/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.WatermarkDataBase;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Class for insert watermark image request building.")
public class WatermarkDataImage
extends WatermarkDataBase {
    @SerializedName(value="Image")
    protected FileReference image = null;
    @SerializedName(value="IsWashout")
    protected Boolean isWashout = null;
    @SerializedName(value="Scale")
    protected Double scale = null;

    @ApiModelProperty(value="Gets or sets the watermark image.")
    public FileReference getImage() {
        return this.image;
    }

    public WatermarkDataImage image(FileReference image) {
        this.image = image;
        return this;
    }

    public void setImage(FileReference image) {
        this.image = image;
    }

    @ApiModelProperty(value="Gets or sets a boolean value which is responsible for washout effect of the watermark. The default value is true.")
    public Boolean getIsWashout() {
        return this.isWashout;
    }

    public WatermarkDataImage isWashout(Boolean isWashout) {
        this.isWashout = isWashout;
        return this;
    }

    public void setIsWashout(Boolean isWashout) {
        this.isWashout = isWashout;
    }

    @ApiModelProperty(value="Gets or sets the scale factor expressed as a fraction of the image. The default value is 0 - auto. Valid values range from 0 to 65.5 inclusive. Auto scale means that the watermark will be scaled to its max width and max height relative to the page margins.")
    public Double getScale() {
        return this.scale;
    }

    public WatermarkDataImage scale(Double scale) {
        this.scale = scale;
        return this;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        super.getFilesContent(resultFilesContent);
        if (this.image != null) {
            this.image.getFilesContent(resultFilesContent);
        }
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.image == null) {
            throw new ApiException(400, "Property Image in WatermarkDataImage is required.");
        }
        if (this.image != null) {
            this.image.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkDataImage watermarkDataImage = (WatermarkDataImage)o;
        return Objects.equals(this.image, watermarkDataImage.image) && Objects.equals(this.isWashout, watermarkDataImage.isWashout) && Objects.equals(this.scale, watermarkDataImage.scale) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.image, this.isWashout, this.scale, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatermarkDataImage {\n");
        sb.append("    image: ").append(this.toIndentedString(this.getImage())).append("\n");
        sb.append("    isWashout: ").append(this.toIndentedString(this.getIsWashout())).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.getScale())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

