/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents options for XML data loading. To learn more, visit the LINQ Reporting Engine documentation article. An instance of this class can be passed into constructors of XmlDataSource.")
public class XmlDataLoadOptions
implements ModelIfc {
    @SerializedName(value="AlwaysGenerateRootObject")
    protected Boolean alwaysGenerateRootObject = null;

    @ApiModelProperty(value="Gets or sets a flag indicating whether a generated data source will always contain an object for an XML root element. If an XML root element has no attributes and all its child elements have same names, such an object is not created by default. The default value is false.")
    public Boolean getAlwaysGenerateRootObject() {
        return this.alwaysGenerateRootObject;
    }

    public XmlDataLoadOptions alwaysGenerateRootObject(Boolean alwaysGenerateRootObject) {
        this.alwaysGenerateRootObject = alwaysGenerateRootObject;
        return this;
    }

    public void setAlwaysGenerateRootObject(Boolean alwaysGenerateRootObject) {
        this.alwaysGenerateRootObject = alwaysGenerateRootObject;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.alwaysGenerateRootObject == null) {
            throw new ApiException(400, "Property AlwaysGenerateRootObject in XmlDataLoadOptions is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlDataLoadOptions xmlDataLoadOptions = (XmlDataLoadOptions)o;
        return Objects.equals(this.alwaysGenerateRootObject, xmlDataLoadOptions.alwaysGenerateRootObject);
    }

    public int hashCode() {
        return Objects.hash(this.alwaysGenerateRootObject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XmlDataLoadOptions {\n");
        sb.append("    alwaysGenerateRootObject: ").append(this.toIndentedString(this.getAlwaysGenerateRootObject())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

