/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model.requests;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.Pair;
import com.aspose.words.cloud.ProgressRequestBody;
import com.aspose.words.cloud.ProgressResponseBody;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ReportEngineSettings;
import com.aspose.words.cloud.model.requests.RequestIfc;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class BuildReportOnlineRequest
implements RequestIfc {
    private byte[] template;
    private String data;
    private ReportEngineSettings reportEngineSettings;
    private String documentFileName;

    public BuildReportOnlineRequest(byte[] template, String data, ReportEngineSettings reportEngineSettings, String documentFileName) {
        this.template = template;
        this.data = data;
        this.reportEngineSettings = reportEngineSettings;
        this.documentFileName = documentFileName;
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public void setTemplate(byte[] value) {
        this.template = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        this.data = value;
    }

    public ReportEngineSettings getReportEngineSettings() {
        return this.reportEngineSettings;
    }

    public void setReportEngineSettings(ReportEngineSettings value) {
        this.reportEngineSettings = value;
    }

    public String getDocumentFileName() {
        return this.documentFileName;
    }

    public void setDocumentFileName(String value) {
        this.documentFileName = value;
    }

    @Override
    public Request buildHttpRequest(ApiClient apiClient, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, Boolean addAuthHeaders) throws ApiException, IOException {
        if (this.getTemplate() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'Template' when calling buildReportOnline");
        }
        if (this.getData() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'Data' when calling buildReportOnline");
        }
        if (this.getReportEngineSettings() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'ReportEngineSettings' when calling buildReportOnline");
        }
        if (this.getReportEngineSettings() != null) {
            this.getReportEngineSettings().validate();
        }
        String localVarPath = "/words/buildReport";
        localVarPath = localVarPath.replaceAll("//", "/");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        apiClient.addParameterToQuery(localVarQueryParams, "documentFileName", this.getDocumentFileName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        ArrayList<FileReference> localFilesContentParams = new ArrayList<FileReference>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        if (this.getTemplate() != null) {
            localVarFormParams.put("Template", this.getTemplate());
        }
        if (this.getData() != null) {
            localVarFormParams.put("Data", this.getData());
        }
        if (this.getReportEngineSettings() != null) {
            localVarFormParams.put("ReportEngineSettings", this.getReportEngineSettings());
        }
        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){
                final /* synthetic */ BuildReportOnlineRequest this$0;
                {
                    this.this$0 = this$0;
                }

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return apiClient.buildRequest(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarHeaderParams, localVarFormParams, localFilesContentParams, addAuthHeaders, progressRequestListener);
    }

    public byte[] deserializeResponse(ApiClient apiClient, Response response) throws ApiException, MessagingException, IOException {
        return response.body().bytes();
    }
}

