/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.ParagraphInsert;
import com.aspose.words.cloud.model.ParagraphLinkCollectionResponse;
import com.aspose.words.cloud.model.ParagraphResponse;
import com.aspose.words.cloud.model.ReportEngineSettings;
import com.aspose.words.cloud.model.requests.BatchPartRequest;
import com.aspose.words.cloud.model.requests.BuildReportOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphRequest;
import com.aspose.words.cloud.model.requests.GetParagraphRequest;
import com.aspose.words.cloud.model.requests.GetParagraphsRequest;
import com.aspose.words.cloud.model.requests.InsertParagraphRequest;
import com.aspose.words.cloud.model.requests.RequestIfc;
import com.aspose.words.cloud.model.requests.UploadFileRequest;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestBatch
extends TestCase {
    private String testFolder = "DocumentElements/Paragraphs";
    private String reportingFolder = "DocumentActions/Reporting";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testBatch() throws ApiException, MessagingException, IOException {
        String fileName = "test_multi_pages.docx";
        String remoteName = "TestGetDocumentParagraphByIndex.docx";
        String remoteFolder = PathUtil.get(TestInitializer.RemoteTestFolder, this.testFolder);
        String file = PathUtil.get(TestInitializer.LocalCommonFolder, fileName);
        String remote_path = PathUtil.get(remoteFolder, remoteName).replace("\\", "/");
        UploadFileRequest request0 = new UploadFileRequest(Files.readAllBytes(new File(file).toPath()), remote_path, null);
        BatchPartRequest request1 = new BatchPartRequest((RequestIfc)new GetParagraphsRequest(remoteName, "sections/0", remoteFolder, null, null, null, null, null));
        BatchPartRequest request2 = new BatchPartRequest((RequestIfc)new GetParagraphRequest(remoteName, Integer.valueOf(0), "sections/0", remoteFolder, null, null, null, null, null));
        ParagraphInsert request3body = new ParagraphInsert();
        request3body.setText("This is a new paragraph for your document");
        BatchPartRequest request3 = new BatchPartRequest((RequestIfc)new InsertParagraphRequest(remoteName, request3body, "sections/0", remoteFolder, null, null, null, null, null, null, null, null));
        BatchPartRequest request4 = new BatchPartRequest((RequestIfc)new DeleteParagraphRequest(remoteName, Integer.valueOf(0), "", remoteFolder, null, null, null, null, null, null, null, null));
        String localDocumentFile = "ReportTemplate.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/ReportData.json")), "utf8");
        ReportEngineSettings requestReportEngineSettings = new ReportEngineSettings();
        requestReportEngineSettings.setDataSourceType(ReportEngineSettings.DataSourceTypeEnum.JSON);
        requestReportEngineSettings.setDataSourceName("persons");
        BatchPartRequest request5 = new BatchPartRequest((RequestIfc)new BuildReportOnlineRequest(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/" + localDocumentFile).toAbsolutePath()), localDataFile, requestReportEngineSettings, null));
        TestInitializer.wordsApi.uploadFile(request0);
        Object[] result = TestInitializer.wordsApi.batch(new BatchPartRequest[]{request1, request2, request3, request4, request5});
        TestBatch.assertEquals((int)5, (int)result.length);
        TestBatch.assertTrue((boolean)(result[0] instanceof ParagraphLinkCollectionResponse));
        TestBatch.assertTrue((boolean)(result[1] instanceof ParagraphResponse));
        TestBatch.assertTrue((boolean)(result[2] instanceof ParagraphResponse));
        TestBatch.assertNull((Object)result[3]);
        TestBatch.assertTrue((boolean)(result[4] instanceof byte[]));
    }
}

