/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.api.WordsApi;
import com.aspose.words.cloud.model.requests.AcceptAllRevisionsOnlineRequest;
import com.aspose.words.cloud.model.requests.AcceptAllRevisionsRequest;
import com.aspose.words.cloud.model.requests.UploadFileRequest;
import com.aspose.words.cloud.model.responses.AcceptAllRevisionsOnlineResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestExamples
extends TestCase {
    private ApiClient apiClient;

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
        this.apiClient = TestInitializer.apiClient;
        WordsApi api = new WordsApi(this.apiClient);
        api.uploadFile(new UploadFileRequest(Files.readAllBytes(Paths.get("ExamplesData", "test_doc.docx").toAbsolutePath()), "test_doc.docx", null));
    }

    @Test
    public void testAcceptAllRevisions() throws Exception {
        String documentsDir = "ExamplesData";
        WordsApi wordsApi = new WordsApi(this.apiClient);
        String fileName = "test_doc.docx";
        byte[] myVar1 = Files.readAllBytes(Paths.get(documentsDir, fileName).toAbsolutePath());
        String myVar2 = fileName;
        UploadFileRequest uploadFileRequest = new UploadFileRequest(myVar1, myVar2, null);
        wordsApi.uploadFile(uploadFileRequest);
        String myVar3 = fileName;
        AcceptAllRevisionsRequest request = new AcceptAllRevisionsRequest(myVar3, null, null, null, null, null, null, null);
        wordsApi.acceptAllRevisions(request);
    }

    @Test
    public void testAcceptAllRevisionsOnline() throws Exception {
        String documentsDir = "ExamplesData";
        WordsApi wordsApi = new WordsApi(this.apiClient);
        String fileName = "test_doc.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(documentsDir, fileName).toAbsolutePath());
        AcceptAllRevisionsOnlineRequest request = new AcceptAllRevisionsOnlineRequest(requestDocument, null, null, null, null, null);
        AcceptAllRevisionsOnlineResponse acceptAllRevisionsOnlineResult = wordsApi.acceptAllRevisionsOnline(request);
        Files.write(Paths.get("test_result.docx", new String[0]), (byte[])acceptAllRevisionsOnlineResult.getDocument().values().iterator().next(), new OpenOption[0]);
    }
}

