/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.api.WordsApi;
import com.aspose.words.cloud.model.FilesUploadResult;
import com.aspose.words.cloud.model.requests.UploadFileRequest;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Map;

public final class TestInitializer {
    public static ApiClient apiClient;
    public static WordsApi wordsApi;
    public static String LocalTestFolder;
    public static String LocalCommonFolder;
    public static String RemoteTestFolder;
    public static String RemoteTestOut;
    public static final String CONFIG_PATH = "Settings/servercreds.json";

    public static void Initialize() throws FileNotFoundException, ApiException {
        TestInitializer.Initialize(CONFIG_PATH);
    }

    public static void Initialize(String credsPath) throws FileNotFoundException, ApiException {
        Map<String, String> creds = TestInitializer.GetConfig(credsPath);
        apiClient = new ApiClient(creds.get("ClientId"), creds.get("ClientSecret"), creds.get("BaseUrl"));
        wordsApi = new WordsApi(apiClient);
    }

    public static Map<String, String> GetConfig(String credsPath) throws FileNotFoundException {
        Map creds = (Map)new Gson().fromJson(new JsonReader((Reader)new FileReader(credsPath)), Map.class);
        if (creds == null) {
            throw new FileNotFoundException("Please put your credentials into Settings/servercreds.json file");
        }
        return creds;
    }

    public static FilesUploadResult UploadFile(String file, String path) throws IOException, MessagingException, ApiException {
        UploadFileRequest request = new UploadFileRequest(Files.readAllBytes(new File(file).toPath()), path, null);
        return wordsApi.uploadFile(request);
    }

    static {
        LocalTestFolder = "TestData";
        LocalCommonFolder = PathUtil.get(LocalTestFolder, "Common");
        RemoteTestFolder = PathUtil.get("Temp", "SdkTests", "Java", "TestData");
        RemoteTestOut = PathUtil.get("TestOut", "Java");
    }
}

