/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.api.WordsApi;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.requests.DeleteWatermarkRequest;
import com.aspose.words.cloud.model.requests.UploadFileRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestReadme
extends TestCase {
    @Test
    public void testReadmeCode() throws ApiException, MessagingException, IOException {
        Map<String, String> creds = TestInitializer.GetConfig("Settings/servercreds.json");
        String clientId = creds.get("ClientId");
        String clientSecret = creds.get("ClientSecret");
        String baseUrl = creds.get("BaseUrl");
        String localFolder = TestInitializer.LocalCommonFolder;
        String fileName = "test_multi_pages.docx";
        String remoteFolder = "TestFolder";
        String remoteName = "TestDeleteDocumentWatermark.docx";
        WordsApi wordsApi = new WordsApi(clientId, clientSecret, baseUrl);
        String localPath = PathUtil.get(localFolder, fileName);
        String remotePath = PathUtil.get(remoteFolder, remoteName);
        UploadFileRequest uploadRequest = new UploadFileRequest(Files.readAllBytes(Paths.get(localPath, new String[0])), remotePath, null);
        wordsApi.uploadFile(uploadRequest);
        DeleteWatermarkRequest request = new DeleteWatermarkRequest(remoteName, remoteFolder, null, null, null, null, null, null, null, null);
        DocumentResponse result = wordsApi.deleteWatermark(request);
        this.writeToReadme();
    }

    private void writeToReadme() throws IOException {
        String startPattern = "^\\s*// Start README example\\s*$";
        String endPattern = "^\\s*// End README example\\s*$";
        String sourcePath = "src/test/java/com/aspose/words/cloud/TestReadme.java";
        String readmePath = "README.md";
        List<String> codeLines = Files.readAllLines(Paths.get(sourcePath, new String[0]));
        ArrayList<String> readmeCode = new ArrayList<String>();
        boolean skipMode = true;
        for (String line : codeLines) {
            if (skipMode) {
                boolean bl = skipMode = !line.matches(startPattern);
            }
            if (skipMode) continue;
            readmeCode.add(line);
            skipMode = line.matches(endPattern);
        }
        List<String> readmeLines = Files.readAllLines(Paths.get(readmePath, new String[0]));
        ArrayList<String> newReadmeLines = new ArrayList<String>();
        boolean codeMode = false;
        for (String line : readmeLines) {
            if (!codeMode && (codeMode = line.matches(startPattern))) {
                newReadmeLines.addAll(readmeCode);
            }
            if (codeMode) {
                codeMode = !line.matches(endPattern);
                continue;
            }
            if (codeMode) continue;
            newReadmeLines.add(line);
        }
        Files.write(Paths.get(readmePath, new String[0]), newReadmeLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

