/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.compatibility;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.OptimizationOptions;
import com.aspose.words.cloud.model.requests.OptimizeDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.OptimizeDocumentRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestCompatibility
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/Compatibility";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testOptimizeDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestOptimizeDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        OptimizationOptions requestOptions = new OptimizationOptions();
        requestOptions.setMsWordVersion(OptimizationOptions.MsWordVersionEnum.WORD2002);
        OptimizeDocumentRequest request = new OptimizeDocumentRequest(remoteFileName, requestOptions, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.optimizeDocument(request);
    }

    @Test
    public void testOptimizeDocumentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        OptimizationOptions requestOptions = new OptimizationOptions();
        requestOptions.setMsWordVersion(OptimizationOptions.MsWordVersionEnum.WORD2002);
        OptimizeDocumentOnlineRequest request = new OptimizeDocumentOnlineRequest(requestDocument, requestOptions, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.optimizeDocumentOnline(request);
        TestCompatibility.assertNotNull((Object)result);
    }
}

