/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Comment;
import com.aspose.words.cloud.model.CommentInsert;
import com.aspose.words.cloud.model.CommentResponse;
import com.aspose.words.cloud.model.CommentUpdate;
import com.aspose.words.cloud.model.CommentsResponse;
import com.aspose.words.cloud.model.PositionInsideNode;
import com.aspose.words.cloud.model.requests.DeleteCommentOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteCommentRequest;
import com.aspose.words.cloud.model.requests.DeleteCommentsOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteCommentsRequest;
import com.aspose.words.cloud.model.requests.GetCommentOnlineRequest;
import com.aspose.words.cloud.model.requests.GetCommentRequest;
import com.aspose.words.cloud.model.requests.GetCommentsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetCommentsRequest;
import com.aspose.words.cloud.model.requests.InsertCommentOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertCommentRequest;
import com.aspose.words.cloud.model.requests.UpdateCommentOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateCommentRequest;
import com.aspose.words.cloud.model.responses.InsertCommentOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateCommentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestComment
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/Comments";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetComment() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetComment.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetCommentRequest request = new GetCommentRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        CommentResponse result = TestInitializer.wordsApi.getComment(request);
        TestComment.assertNotNull((Object)result);
        TestComment.assertNotNull((Object)result.getComment());
        TestComment.assertEquals((String)"Comment 1\r\n\r\n", (String)result.getComment().getText());
    }

    @Test
    public void testGetCommentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetCommentOnlineRequest request = new GetCommentOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null);
        CommentResponse result = TestInitializer.wordsApi.getCommentOnline(request);
        TestComment.assertNotNull((Object)result);
    }

    @Test
    public void testGetComments() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetComments.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetCommentsRequest request = new GetCommentsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        CommentsResponse result = TestInitializer.wordsApi.getComments(request);
        TestComment.assertNotNull((Object)result);
        TestComment.assertNotNull((Object)result.getComments());
        TestComment.assertNotNull((Object)result.getComments().getCommentList());
        TestComment.assertEquals((int)1, (int)result.getComments().getCommentList().size());
        TestComment.assertEquals((String)"Comment 1\r\n\r\n", (String)((Comment)result.getComments().getCommentList().get(0)).getText());
    }

    @Test
    public void testGetCommentsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetCommentsOnlineRequest request = new GetCommentsOnlineRequest(requestDocument, null, null, null, null);
        CommentsResponse result = TestInitializer.wordsApi.getCommentsOnline(request);
        TestComment.assertNotNull((Object)result);
    }

    @Test
    public void testInsertComment() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertComment.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        PositionInsideNode requestCommentRangeStart = new PositionInsideNode();
        requestCommentRangeStart.setNodeId("0.3.0.3");
        requestCommentRangeStart.setOffset(Integer.valueOf(0));
        PositionInsideNode requestCommentRangeEnd = new PositionInsideNode();
        requestCommentRangeEnd.setNodeId("0.3.0.3");
        requestCommentRangeEnd.setOffset(Integer.valueOf(0));
        CommentInsert requestComment = new CommentInsert();
        requestComment.setRangeStart(requestCommentRangeStart);
        requestComment.setRangeEnd(requestCommentRangeEnd);
        requestComment.setInitial("IA");
        requestComment.setAuthor("Imran Anwar");
        requestComment.setText("A new Comment");
        InsertCommentRequest request = new InsertCommentRequest(remoteFileName, requestComment, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        CommentResponse result = TestInitializer.wordsApi.insertComment(request);
        TestComment.assertNotNull((Object)result);
        TestComment.assertNotNull((Object)result.getComment());
        TestComment.assertEquals((String)"A new Comment\r\n", (String)result.getComment().getText());
        TestComment.assertNotNull((Object)result.getComment().getRangeStart());
        TestComment.assertNotNull((Object)result.getComment().getRangeStart().getNode());
        TestComment.assertEquals((String)"0.3.0.4", (String)result.getComment().getRangeStart().getNode().getNodeId());
    }

    @Test
    public void testInsertCommentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        PositionInsideNode requestCommentRangeStart = new PositionInsideNode();
        requestCommentRangeStart.setNodeId("0.3.0.3");
        requestCommentRangeStart.setOffset(Integer.valueOf(0));
        PositionInsideNode requestCommentRangeEnd = new PositionInsideNode();
        requestCommentRangeEnd.setNodeId("0.3.0.3");
        requestCommentRangeEnd.setOffset(Integer.valueOf(0));
        CommentInsert requestComment = new CommentInsert();
        requestComment.setRangeStart(requestCommentRangeStart);
        requestComment.setRangeEnd(requestCommentRangeEnd);
        requestComment.setInitial("IA");
        requestComment.setAuthor("Imran Anwar");
        requestComment.setText("A new Comment");
        InsertCommentOnlineRequest request = new InsertCommentOnlineRequest(requestDocument, requestComment, null, null, null, null, null, null, null);
        InsertCommentOnlineResponse result = TestInitializer.wordsApi.insertCommentOnline(request);
        TestComment.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateComment() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateComment.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        PositionInsideNode requestCommentRangeStart = new PositionInsideNode();
        requestCommentRangeStart.setNodeId("0.3.0");
        requestCommentRangeStart.setOffset(Integer.valueOf(0));
        PositionInsideNode requestCommentRangeEnd = new PositionInsideNode();
        requestCommentRangeEnd.setNodeId("0.3.0");
        requestCommentRangeEnd.setOffset(Integer.valueOf(0));
        CommentUpdate requestComment = new CommentUpdate();
        requestComment.setRangeStart(requestCommentRangeStart);
        requestComment.setRangeEnd(requestCommentRangeEnd);
        requestComment.setInitial("IA");
        requestComment.setAuthor("Imran Anwar");
        requestComment.setText("A new Comment");
        UpdateCommentRequest request = new UpdateCommentRequest(remoteFileName, Integer.valueOf(0), requestComment, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        CommentResponse result = TestInitializer.wordsApi.updateComment(request);
        TestComment.assertNotNull((Object)result);
        TestComment.assertNotNull((Object)result.getComment());
        TestComment.assertEquals((String)"A new Comment\r\n", (String)result.getComment().getText());
        TestComment.assertNotNull((Object)result.getComment().getRangeStart());
        TestComment.assertNotNull((Object)result.getComment().getRangeStart().getNode());
        TestComment.assertEquals((String)"0.3.0.1", (String)result.getComment().getRangeStart().getNode().getNodeId());
    }

    @Test
    public void testUpdateCommentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        PositionInsideNode requestCommentRangeStart = new PositionInsideNode();
        requestCommentRangeStart.setNodeId("0.3.0");
        requestCommentRangeStart.setOffset(Integer.valueOf(0));
        PositionInsideNode requestCommentRangeEnd = new PositionInsideNode();
        requestCommentRangeEnd.setNodeId("0.3.0");
        requestCommentRangeEnd.setOffset(Integer.valueOf(0));
        CommentUpdate requestComment = new CommentUpdate();
        requestComment.setRangeStart(requestCommentRangeStart);
        requestComment.setRangeEnd(requestCommentRangeEnd);
        requestComment.setInitial("IA");
        requestComment.setAuthor("Imran Anwar");
        requestComment.setText("A new Comment");
        UpdateCommentOnlineRequest request = new UpdateCommentOnlineRequest(requestDocument, Integer.valueOf(0), requestComment, null, null, null, null, null, null, null);
        UpdateCommentOnlineResponse result = TestInitializer.wordsApi.updateCommentOnline(request);
        TestComment.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteComment() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteComment.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteCommentRequest request = new DeleteCommentRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteComment(request);
    }

    @Test
    public void testDeleteCommentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteCommentOnlineRequest request = new DeleteCommentOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteCommentOnline(request);
        TestComment.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteComments() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteComment.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteCommentsRequest request = new DeleteCommentsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteComments(request);
    }

    @Test
    public void testDeleteCommentsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteCommentsOnlineRequest request = new DeleteCommentsOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteCommentsOnline(request);
        TestComment.assertNotNull((Object)result);
    }
}

