/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.CompareData;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.requests.CompareDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.CompareDocumentRequest;
import com.aspose.words.cloud.model.responses.CompareDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneOffset;

public class TestCompareDocument
extends TestCase {
    private String remoteFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/CompareDocument";
    private String localFolder = "DocumentActions/CompareDocument";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testCompareDocument() throws ApiException, MessagingException, IOException {
        String localName1 = "compareTestDoc1.doc";
        String localName2 = "compareTestDoc2.doc";
        String remoteName1 = "TestCompareDocument1.doc";
        String remoteName2 = "TestCompareDocument2.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName1), this.remoteFolder + "/" + remoteName1);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName2), this.remoteFolder + "/" + remoteName2);
        FileReference requestCompareDataFileReference = new FileReference(this.remoteFolder + "/" + remoteName2);
        CompareData requestCompareData = new CompareData();
        requestCompareData.setAuthor("author");
        requestCompareData.setDateTime(OffsetDateTime.of((int)2015, (int)10, (int)26, (int)0, (int)0, (int)0, (int)0, (ZoneOffset)ZoneOffset.UTC));
        requestCompareData.setFileReference(requestCompareDataFileReference);
        CompareDocumentRequest request = new CompareDocumentRequest(remoteName1, requestCompareData, this.remoteFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/TestCompareDocumentOut.doc", null);
        DocumentResponse result = TestInitializer.wordsApi.compareDocument(request);
        TestCompareDocument.assertNotNull((Object)result);
        TestCompareDocument.assertNotNull((Object)result.getDocument());
        TestCompareDocument.assertEquals((String)"TestCompareDocumentOut.doc", (String)result.getDocument().getFileName());
    }

    @Test
    public void testCompareDocumentOnline() throws ApiException, MessagingException, IOException {
        String localName1 = "compareTestDoc1.doc";
        String localName2 = "compareTestDoc2.doc";
        String remoteName2 = "TestCompareDocument2.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName2), this.remoteFolder + "/" + remoteName2);
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName1).toAbsolutePath());
        FileReference requestCompareDataFileReference = new FileReference(this.remoteFolder + "/" + remoteName2);
        CompareData requestCompareData = new CompareData();
        requestCompareData.setAuthor("author");
        requestCompareData.setDateTime(OffsetDateTime.of((int)2015, (int)10, (int)26, (int)0, (int)0, (int)0, (int)0, (ZoneOffset)ZoneOffset.UTC));
        requestCompareData.setFileReference(requestCompareDataFileReference);
        CompareDocumentOnlineRequest request = new CompareDocumentOnlineRequest(requestDocument, requestCompareData, null, null, null, null, TestInitializer.RemoteTestOut + "/TestCompareDocumentOut.doc", null);
        CompareDocumentOnlineResponse result = TestInitializer.wordsApi.compareDocumentOnline(request);
        TestCompareDocument.assertNotNull((Object)result);
    }

    @Test
    public void testCompareTwoDocumentOnline() throws ApiException, MessagingException, IOException {
        String localName1 = "compareTestDoc1.doc";
        String localName2 = "compareTestDoc2.doc";
        String remoteName2 = "TestCompareDocument2.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName2), this.remoteFolder + "/" + remoteName2);
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName1).toAbsolutePath());
        byte[] requestCompareDataFileReferenceStream = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName2).toAbsolutePath());
        FileReference requestCompareDataFileReference = new FileReference(requestCompareDataFileReferenceStream);
        CompareData requestCompareData = new CompareData();
        requestCompareData.setAuthor("author");
        requestCompareData.setDateTime(OffsetDateTime.of((int)2015, (int)10, (int)26, (int)0, (int)0, (int)0, (int)0, (ZoneOffset)ZoneOffset.UTC));
        requestCompareData.setFileReference(requestCompareDataFileReference);
        CompareDocumentOnlineRequest request = new CompareDocumentOnlineRequest(requestDocument, requestCompareData, null, null, null, null, TestInitializer.RemoteTestOut + "/TestCompareDocumentOut.doc", null);
        CompareDocumentOnlineResponse result = TestInitializer.wordsApi.compareDocumentOnline(request);
        TestCompareDocument.assertNotNull((Object)result);
    }

    @Test
    public void testCompareDocumentWithPassword() throws ApiException, MessagingException, IOException {
        String localName = "DocWithPassword.docx";
        String remoteName1 = "TestCompareDocument1.docx";
        String remoteName2 = "TestCompareDocument2.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localName), this.remoteFolder + "/" + remoteName1);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localName), this.remoteFolder + "/" + remoteName2);
        FileReference requestCompareDataFileReference = new FileReference(this.remoteFolder + "/" + remoteName2, "12345");
        CompareData requestCompareData = new CompareData();
        requestCompareData.setAuthor("author");
        requestCompareData.setDateTime(OffsetDateTime.of((int)2015, (int)10, (int)26, (int)0, (int)0, (int)0, (int)0, (ZoneOffset)ZoneOffset.UTC));
        requestCompareData.setFileReference(requestCompareDataFileReference);
        CompareDocumentRequest request = new CompareDocumentRequest(remoteName1, requestCompareData, this.remoteFolder, null, null, "12345", null, null, TestInitializer.RemoteTestOut + "/TestCompareDocumentOut.docx", null);
        DocumentResponse result = TestInitializer.wordsApi.compareDocument(request);
        TestCompareDocument.assertNotNull((Object)result);
        TestCompareDocument.assertNotNull((Object)result.getDocument());
        TestCompareDocument.assertEquals((String)"TestCompareDocumentOut.docx", (String)result.getDocument().getFileName());
    }
}

