/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocSaveOptionsData;
import com.aspose.words.cloud.model.LoadWebDocumentData;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.aspose.words.cloud.model.SaveResponse;
import com.aspose.words.cloud.model.requests.LoadWebDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.LoadWebDocumentRequest;
import com.aspose.words.cloud.model.responses.LoadWebDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;

public class TestLoadWebDocument
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testLoadWebDocument() throws ApiException, MessagingException, IOException {
        DocSaveOptionsData requestDataSaveOptions = new DocSaveOptionsData();
        requestDataSaveOptions.setFileName("google.doc");
        requestDataSaveOptions.setDmlEffectsRenderingMode(SaveOptionsData.DmlEffectsRenderingModeEnum.NONE);
        requestDataSaveOptions.setDmlRenderingMode(SaveOptionsData.DmlRenderingModeEnum.DRAWINGML);
        requestDataSaveOptions.setZipOutput(Boolean.valueOf(false));
        LoadWebDocumentData requestData = new LoadWebDocumentData();
        requestData.setLoadingDocumentUrl("http://google.com");
        requestData.setSaveOptions((SaveOptionsData)requestDataSaveOptions);
        LoadWebDocumentRequest request = new LoadWebDocumentRequest(requestData, null);
        SaveResponse result = TestInitializer.wordsApi.loadWebDocument(request);
        TestLoadWebDocument.assertNotNull((Object)result);
        TestLoadWebDocument.assertNotNull((Object)result.getSaveResult());
        TestLoadWebDocument.assertNotNull((Object)result.getSaveResult().getDestDocument());
        TestLoadWebDocument.assertEquals((String)"google.doc", (String)result.getSaveResult().getDestDocument().getHref());
    }

    @Test
    public void testLoadWebDocumentOnline() throws ApiException, MessagingException, IOException {
        DocSaveOptionsData requestDataSaveOptions = new DocSaveOptionsData();
        requestDataSaveOptions.setFileName("google.doc");
        requestDataSaveOptions.setDmlEffectsRenderingMode(SaveOptionsData.DmlEffectsRenderingModeEnum.NONE);
        requestDataSaveOptions.setDmlRenderingMode(SaveOptionsData.DmlRenderingModeEnum.DRAWINGML);
        requestDataSaveOptions.setZipOutput(Boolean.valueOf(false));
        LoadWebDocumentData requestData = new LoadWebDocumentData();
        requestData.setLoadingDocumentUrl("http://google.com");
        requestData.setSaveOptions((SaveOptionsData)requestDataSaveOptions);
        LoadWebDocumentOnlineRequest request = new LoadWebDocumentOnlineRequest(requestData);
        LoadWebDocumentOnlineResponse result = TestInitializer.wordsApi.loadWebDocumentOnline(request);
        TestLoadWebDocument.assertNotNull((Object)result);
    }
}

