/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.SignatureCollectionResponse;
import com.aspose.words.cloud.model.requests.GetSignaturesOnlineRequest;
import com.aspose.words.cloud.model.requests.GetSignaturesRequest;
import com.aspose.words.cloud.model.requests.RemoveAllSignaturesOnlineRequest;
import com.aspose.words.cloud.model.requests.RemoveAllSignaturesRequest;
import com.aspose.words.cloud.model.requests.SignDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.SignDocumentRequest;
import com.aspose.words.cloud.model.responses.RemoveAllSignaturesOnlineResponse;
import com.aspose.words.cloud.model.responses.SignDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestSignature
extends TestCase {
    private String remoteFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Signature";
    private String localFolder = "DocumentActions/Signature";
    private String signedDocument = "signedDocument.docx";
    private String unsignedDocument = "unsignedDocument.docx";
    private String certificateName = "morzal.pfx";
    private String certificatePassword = "aw";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetSignatures() throws ApiException, MessagingException, IOException {
        String remoteName = "TestGetSignatures.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.signedDocument), this.remoteFolder + "/" + remoteName);
        GetSignaturesRequest request = new GetSignaturesRequest(remoteName, this.remoteFolder, null, null, null, null, null);
        SignatureCollectionResponse result = TestInitializer.wordsApi.getSignatures(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getSignatures());
        TestSignature.assertEquals((int)1, (int)result.getSignatures().size());
    }

    @Test
    public void testGetSignaturesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.signedDocument).toAbsolutePath());
        GetSignaturesOnlineRequest request = new GetSignaturesOnlineRequest(requestDocument, null, null, null, null);
        SignatureCollectionResponse result = TestInitializer.wordsApi.getSignaturesOnline(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getSignatures());
        TestSignature.assertEquals((int)1, (int)result.getSignatures().size());
    }

    @Test
    public void testRemoveAllSignatures() throws ApiException, MessagingException, IOException {
        String remoteName = "TestRemoveAllSignatures.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.signedDocument), this.remoteFolder + "/" + remoteName);
        RemoveAllSignaturesRequest request = new RemoveAllSignaturesRequest(remoteName, this.remoteFolder, null, null, null, null, null, null);
        SignatureCollectionResponse result = TestInitializer.wordsApi.removeAllSignatures(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getSignatures());
        TestSignature.assertEquals((int)0, (int)result.getSignatures().size());
    }

    @Test
    public void testRemoveAllSignaturesOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.signedDocument).toAbsolutePath());
        RemoveAllSignaturesOnlineRequest request = new RemoveAllSignaturesOnlineRequest(requestDocument, null, null, null, null, null);
        RemoveAllSignaturesOnlineResponse result = TestInitializer.wordsApi.removeAllSignaturesOnline(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getModel().getSignatures());
        TestSignature.assertEquals((int)0, (int)result.getModel().getSignatures().size());
    }

    @Test
    public void testSignDocument() throws ApiException, MessagingException, IOException {
        String remoteName = "TestSignDocument.docx";
        String remoteCertificateName = "TestCertificate.pfx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.unsignedDocument), this.remoteFolder + "/" + remoteName);
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.certificateName), this.remoteFolder + "/" + remoteCertificateName);
        SignDocumentRequest request = new SignDocumentRequest(remoteName, this.remoteFolder + "/" + remoteCertificateName, this.certificatePassword, this.remoteFolder, null, null, null, null, null, null);
        SignatureCollectionResponse result = TestInitializer.wordsApi.signDocument(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getSignatures());
        TestSignature.assertEquals((int)1, (int)result.getSignatures().size());
    }

    @Test
    public void testSignDocumentOnline() throws ApiException, MessagingException, IOException {
        String remoteCertificateName = "TestCertificateOnline.pfx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.certificateName), this.remoteFolder + "/" + remoteCertificateName);
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + this.unsignedDocument).toAbsolutePath());
        SignDocumentOnlineRequest request = new SignDocumentOnlineRequest(requestDocument, this.remoteFolder + "/" + remoteCertificateName, this.certificatePassword, null, null, null, null, null);
        SignDocumentOnlineResponse result = TestInitializer.wordsApi.signDocumentOnline(request);
        TestSignature.assertNotNull((Object)result);
        TestSignature.assertNotNull((Object)result.getModel().getSignatures());
        TestSignature.assertEquals((int)1, (int)result.getModel().getSignatures().size());
    }
}

