/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.documentProtection;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.ProtectionDataResponse;
import com.aspose.words.cloud.model.ProtectionRequestBase;
import com.aspose.words.cloud.model.ProtectionRequestV2;
import com.aspose.words.cloud.model.requests.GetDocumentProtectionOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentProtectionRequest;
import com.aspose.words.cloud.model.requests.ProtectDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.ProtectDocumentRequest;
import com.aspose.words.cloud.model.requests.UnprotectDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.UnprotectDocumentRequest;
import com.aspose.words.cloud.model.responses.ProtectDocumentOnlineResponse;
import com.aspose.words.cloud.model.responses.UnprotectDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDocumentProtection
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/DocumentProtection";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testProtectDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestProtectDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ProtectionRequestV2 requestProtectionRequest = new ProtectionRequestV2();
        requestProtectionRequest.setProtectionPassword("123");
        requestProtectionRequest.setProtectionType(ProtectionRequestV2.ProtectionTypeEnum.READONLY);
        ProtectDocumentRequest request = new ProtectDocumentRequest(remoteFileName, (ProtectionRequestBase)requestProtectionRequest, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        ProtectionDataResponse result = TestInitializer.wordsApi.protectDocument(request);
        TestDocumentProtection.assertNotNull((Object)result);
        TestDocumentProtection.assertNotNull((Object)result.getProtectionData());
    }

    @Test
    public void testProtectDocumentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ProtectionRequestV2 requestProtectionRequest = new ProtectionRequestV2();
        requestProtectionRequest.setProtectionPassword("123");
        requestProtectionRequest.setProtectionType(ProtectionRequestV2.ProtectionTypeEnum.READONLY);
        ProtectDocumentOnlineRequest request = new ProtectDocumentOnlineRequest(requestDocument, (ProtectionRequestBase)requestProtectionRequest, null, null, null, null, null);
        ProtectDocumentOnlineResponse result = TestInitializer.wordsApi.protectDocumentOnline(request);
        TestDocumentProtection.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentProtection() throws ApiException, MessagingException, IOException {
        String localFilePath = "DocumentActions/DocumentProtection/SampleProtectedBlankWordDocument.docx";
        String remoteFileName = "TestGetDocumentProtection.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, localFilePath), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentProtectionRequest request = new GetDocumentProtectionRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        ProtectionDataResponse result = TestInitializer.wordsApi.getDocumentProtection(request);
        TestDocumentProtection.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentProtectionOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentProtectionOnlineRequest request = new GetDocumentProtectionOnlineRequest(requestDocument, null, null, null, null);
        ProtectionDataResponse result = TestInitializer.wordsApi.getDocumentProtectionOnline(request);
        TestDocumentProtection.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteUnprotectDocument() throws ApiException, MessagingException, IOException {
        String localFilePath = "DocumentActions/DocumentProtection/SampleProtectedBlankWordDocument.docx";
        String remoteFileName = "TestDeleteUnprotectDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, localFilePath), this.remoteDataFolder + "/" + remoteFileName);
        UnprotectDocumentRequest request = new UnprotectDocumentRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null);
        ProtectionDataResponse result = TestInitializer.wordsApi.unprotectDocument(request);
        TestDocumentProtection.assertNotNull((Object)result);
        TestDocumentProtection.assertNotNull((Object)result.getProtectionData());
    }

    @Test
    public void testDeleteUnprotectDocumentOnline() throws ApiException, MessagingException, IOException {
        String localFilePath = "DocumentActions/DocumentProtection/SampleProtectedBlankWordDocument.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, localFilePath).toAbsolutePath());
        UnprotectDocumentOnlineRequest request = new UnprotectDocumentOnlineRequest(requestDocument, null, null, null, null, null);
        UnprotectDocumentOnlineResponse result = TestInitializer.wordsApi.unprotectDocumentOnline(request);
        TestDocumentProtection.assertNotNull((Object)result);
    }
}

