/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.drawing;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DrawingObjectInsert;
import com.aspose.words.cloud.model.DrawingObjectResponse;
import com.aspose.words.cloud.model.DrawingObjectUpdate;
import com.aspose.words.cloud.model.DrawingObjectsResponse;
import com.aspose.words.cloud.model.requests.DeleteDrawingObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteDrawingObjectRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectByIndexOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectByIndexRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectImageDataOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectImageDataRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectOleDataOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectOleDataRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentDrawingObjectsRequest;
import com.aspose.words.cloud.model.requests.InsertDrawingObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertDrawingObjectRequest;
import com.aspose.words.cloud.model.requests.RenderDrawingObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.RenderDrawingObjectRequest;
import com.aspose.words.cloud.model.requests.UpdateDrawingObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateDrawingObjectRequest;
import com.aspose.words.cloud.model.responses.InsertDrawingObjectOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateDrawingObjectOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDrawingObjects
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/DrawingObjectss";
    private String localFile = "Common/test_multi_pages.docx";
    private String localDrawingFile = "DocumentElements/DrawingObjects/sample_EmbeddedOLE.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentDrawingObjects() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjects.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectsRequest request = new GetDocumentDrawingObjectsRequest(remoteFileName, "sections/0", this.remoteDataFolder, null, null, null, null, null);
        DrawingObjectsResponse result = TestInitializer.wordsApi.getDocumentDrawingObjects(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentDrawingObjectsOnlineRequest request = new GetDocumentDrawingObjectsOnlineRequest(requestDocument, "sections/0", null, null, null, null);
        DrawingObjectsResponse result = TestInitializer.wordsApi.getDocumentDrawingObjectsOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectsRequest request = new GetDocumentDrawingObjectsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        DrawingObjectsResponse result = TestInitializer.wordsApi.getDocumentDrawingObjects(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectByIndex() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectByIndex.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectByIndexRequest request = new GetDocumentDrawingObjectByIndexRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.getDocumentDrawingObjectByIndex(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectByIndexOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentDrawingObjectByIndexOnlineRequest request = new GetDocumentDrawingObjectByIndexOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.getDocumentDrawingObjectByIndexOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectByIndexWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectByIndexWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectByIndexRequest request = new GetDocumentDrawingObjectByIndexRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.getDocumentDrawingObjectByIndex(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testRenderDrawingObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectByIndexWithFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderDrawingObjectRequest request = new RenderDrawingObjectRequest(remoteFileName, "png", Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testRenderDrawingObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RenderDrawingObjectOnlineRequest request = new RenderDrawingObjectOnlineRequest(requestDocument, "png", Integer.valueOf(0), "sections/0", null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderDrawingObjectOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testRenderDrawingObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectByIndexWithFormatWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderDrawingObjectRequest request = new RenderDrawingObjectRequest(remoteFileName, "png", Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectImageData() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectImageData.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectImageDataRequest request = new GetDocumentDrawingObjectImageDataRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectImageData(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectImageDataOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentDrawingObjectImageDataOnlineRequest request = new GetDocumentDrawingObjectImageDataOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectImageDataOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectImageDataWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectImageDataWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectImageDataRequest request = new GetDocumentDrawingObjectImageDataRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectImageData(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectOleData() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectOleData.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localDrawingFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectOleDataRequest request = new GetDocumentDrawingObjectOleDataRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectOleData(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectOleDataOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localDrawingFile).toAbsolutePath());
        GetDocumentDrawingObjectOleDataOnlineRequest request = new GetDocumentDrawingObjectOleDataOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectOleDataOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentDrawingObjectOleDataWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentDrawingObjectOleDataWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localDrawingFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentDrawingObjectOleDataRequest request = new GetDocumentDrawingObjectOleDataRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.getDocumentDrawingObjectOleData(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testInsertDrawingObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsetDrawingObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DrawingObjectInsert requestDrawingObject = new DrawingObjectInsert();
        requestDrawingObject.setHeight(Double.valueOf(0.0));
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        requestDrawingObject.setTop(Double.valueOf(0.0));
        requestDrawingObject.setWidth(Double.valueOf(0.0));
        requestDrawingObject.setRelativeHorizontalPosition(DrawingObjectInsert.RelativeHorizontalPositionEnum.MARGIN);
        requestDrawingObject.setRelativeVerticalPosition(DrawingObjectInsert.RelativeVerticalPositionEnum.MARGIN);
        requestDrawingObject.setWrapType(DrawingObjectInsert.WrapTypeEnum.INLINE);
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        InsertDrawingObjectRequest request = new InsertDrawingObjectRequest(remoteFileName, requestDrawingObject, requestImageFile, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.insertDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testInsertDrawingObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DrawingObjectInsert requestDrawingObject = new DrawingObjectInsert();
        requestDrawingObject.setHeight(Double.valueOf(0.0));
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        requestDrawingObject.setTop(Double.valueOf(0.0));
        requestDrawingObject.setWidth(Double.valueOf(0.0));
        requestDrawingObject.setRelativeHorizontalPosition(DrawingObjectInsert.RelativeHorizontalPositionEnum.MARGIN);
        requestDrawingObject.setRelativeVerticalPosition(DrawingObjectInsert.RelativeVerticalPositionEnum.MARGIN);
        requestDrawingObject.setWrapType(DrawingObjectInsert.WrapTypeEnum.INLINE);
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        InsertDrawingObjectOnlineRequest request = new InsertDrawingObjectOnlineRequest(requestDocument, requestDrawingObject, requestImageFile, "", null, null, null, null, null, null, null);
        InsertDrawingObjectOnlineResponse result = TestInitializer.wordsApi.insertDrawingObjectOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testInsertDrawingObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsetDrawingObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DrawingObjectInsert requestDrawingObject = new DrawingObjectInsert();
        requestDrawingObject.setHeight(Double.valueOf(0.0));
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        requestDrawingObject.setTop(Double.valueOf(0.0));
        requestDrawingObject.setWidth(Double.valueOf(0.0));
        requestDrawingObject.setRelativeHorizontalPosition(DrawingObjectInsert.RelativeHorizontalPositionEnum.MARGIN);
        requestDrawingObject.setRelativeVerticalPosition(DrawingObjectInsert.RelativeVerticalPositionEnum.MARGIN);
        requestDrawingObject.setWrapType(DrawingObjectInsert.WrapTypeEnum.INLINE);
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        InsertDrawingObjectRequest request = new InsertDrawingObjectRequest(remoteFileName, requestDrawingObject, requestImageFile, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.insertDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteDrawingObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteDrawingObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteDrawingObjectRequest request = new DeleteDrawingObjectRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteDrawingObject(request);
    }

    @Test
    public void testDeleteDrawingObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteDrawingObjectOnlineRequest request = new DeleteDrawingObjectOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteDrawingObjectOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteDrawingObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteDrawingObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteDrawingObjectRequest request = new DeleteDrawingObjectRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteDrawingObject(request);
    }

    @Test
    public void testUpdateDrawingObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateDrawingObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DrawingObjectUpdate requestDrawingObject = new DrawingObjectUpdate();
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        UpdateDrawingObjectRequest request = new UpdateDrawingObjectRequest(remoteFileName, requestDrawingObject, requestImageFile, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.updateDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateDrawingObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DrawingObjectUpdate requestDrawingObject = new DrawingObjectUpdate();
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        UpdateDrawingObjectOnlineRequest request = new UpdateDrawingObjectOnlineRequest(requestDocument, requestDrawingObject, requestImageFile, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        UpdateDrawingObjectOnlineResponse result = TestInitializer.wordsApi.updateDrawingObjectOnline(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateDrawingObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateDrawingObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DrawingObjectUpdate requestDrawingObject = new DrawingObjectUpdate();
        requestDrawingObject.setLeft(Double.valueOf(0.0));
        byte[] requestImageFile = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/aspose-cloud.png").toAbsolutePath());
        UpdateDrawingObjectRequest request = new UpdateDrawingObjectRequest(remoteFileName, requestDrawingObject, requestImageFile, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        DrawingObjectResponse result = TestInitializer.wordsApi.updateDrawingObject(request);
        TestDrawingObjects.assertNotNull((Object)result);
    }
}

