/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.field;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.Field;
import com.aspose.words.cloud.model.FieldInsert;
import com.aspose.words.cloud.model.FieldResponse;
import com.aspose.words.cloud.model.FieldUpdate;
import com.aspose.words.cloud.model.FieldsResponse;
import com.aspose.words.cloud.model.PageNumber;
import com.aspose.words.cloud.model.requests.DeleteFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteFieldRequest;
import com.aspose.words.cloud.model.requests.DeleteFieldsOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteFieldsRequest;
import com.aspose.words.cloud.model.requests.GetFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFieldRequest;
import com.aspose.words.cloud.model.requests.GetFieldsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFieldsRequest;
import com.aspose.words.cloud.model.requests.InsertFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertFieldRequest;
import com.aspose.words.cloud.model.requests.InsertPageNumbersOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertPageNumbersRequest;
import com.aspose.words.cloud.model.requests.UpdateFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateFieldRequest;
import com.aspose.words.cloud.model.requests.UpdateFieldsOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateFieldsRequest;
import com.aspose.words.cloud.model.responses.InsertFieldOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertPageNumbersOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateFieldOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateFieldsOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestField
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Fields";
    private String textFolder = "DocumentElements/Text";
    private String fieldFolder = "DocumentElements/Fields";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetFields() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestGetFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        GetFieldsRequest request = new GetFieldsRequest(remoteFileName, "sections/0", this.remoteDataFolder, null, null, null, null, null);
        FieldsResponse result = TestInitializer.wordsApi.getFields(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getFields());
        TestField.assertNotNull((Object)result.getFields().getList());
        TestField.assertEquals((int)1, (int)result.getFields().getList().size());
        TestField.assertEquals((String)"1", (String)((Field)result.getFields().getList().get(0)).getResult());
    }

    @Test
    public void testGetFieldsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/GetField.docx").toAbsolutePath());
        GetFieldsOnlineRequest request = new GetFieldsOnlineRequest(requestDocument, "sections/0", null, null, null, null);
        FieldsResponse result = TestInitializer.wordsApi.getFieldsOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testGetFieldsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestGetFieldsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        GetFieldsRequest request = new GetFieldsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        FieldsResponse result = TestInitializer.wordsApi.getFields(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getFields());
        TestField.assertNotNull((Object)result.getFields().getList());
        TestField.assertEquals((int)1, (int)result.getFields().getList().size());
        TestField.assertEquals((String)"1", (String)((Field)result.getFields().getList().get(0)).getResult());
    }

    @Test
    public void testGetField() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestGetField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        GetFieldRequest request = new GetFieldRequest(remoteFileName, Integer.valueOf(0), "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.getField(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getField());
        TestField.assertEquals((String)"1", (String)result.getField().getResult());
    }

    @Test
    public void testGetFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/GetField.docx").toAbsolutePath());
        GetFieldOnlineRequest request = new GetFieldOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0/paragraphs/0", null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.getFieldOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testGetFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestGetFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        GetFieldRequest request = new GetFieldRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.getField(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getField());
        TestField.assertEquals((String)"1", (String)result.getField().getResult());
    }

    @Test
    public void testInsertField() throws ApiException, MessagingException, IOException {
        String localFileName = "SampleWordDocument.docx";
        String remoteFileName = "TestInsertField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.textFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        FieldInsert requestField = new FieldInsert();
        requestField.setFieldCode("{ NUMPAGES }");
        InsertFieldRequest request = new InsertFieldRequest(remoteFileName, requestField, "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.insertField(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getField());
        TestField.assertEquals((String)"{ NUMPAGES }", (String)result.getField().getFieldCode());
        TestField.assertEquals((String)"0.0.0.1", (String)result.getField().getNodeId());
    }

    @Test
    public void testInsertFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/GetField.docx").toAbsolutePath());
        FieldInsert requestField = new FieldInsert();
        requestField.setFieldCode("{ NUMPAGES }");
        InsertFieldOnlineRequest request = new InsertFieldOnlineRequest(requestDocument, requestField, "sections/0/paragraphs/0", null, null, null, null, null, null, null);
        InsertFieldOnlineResponse result = TestInitializer.wordsApi.insertFieldOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testInsertFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "SampleWordDocument.docx";
        String remoteFileName = "TestInsertFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.textFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        FieldInsert requestField = new FieldInsert();
        requestField.setFieldCode("{ NUMPAGES }");
        InsertFieldRequest request = new InsertFieldRequest(remoteFileName, requestField, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.insertField(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getField());
        TestField.assertEquals((String)"{ NUMPAGES }", (String)result.getField().getFieldCode());
        TestField.assertEquals((String)"5.0.22.0", (String)result.getField().getNodeId());
    }

    @Test
    public void testUpdateField() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestUpdateField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        FieldUpdate requestField = new FieldUpdate();
        requestField.setFieldCode("{ NUMPAGES }");
        UpdateFieldRequest request = new UpdateFieldRequest(remoteFileName, Integer.valueOf(0), requestField, "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        FieldResponse result = TestInitializer.wordsApi.updateField(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getField());
        TestField.assertEquals((String)"{ NUMPAGES }", (String)result.getField().getFieldCode());
        TestField.assertEquals((String)"0.0.0.0", (String)result.getField().getNodeId());
    }

    @Test
    public void testUpdateFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/GetField.docx").toAbsolutePath());
        FieldUpdate requestField = new FieldUpdate();
        requestField.setFieldCode("{ NUMPAGES }");
        UpdateFieldOnlineRequest request = new UpdateFieldOnlineRequest(requestDocument, requestField, Integer.valueOf(0), "sections/0/paragraphs/0", null, null, null, null, null, null, null);
        UpdateFieldOnlineResponse result = TestInitializer.wordsApi.updateFieldOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testInsertPageNumbers() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestInsertPageNumbers.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        PageNumber requestPageNumber = new PageNumber();
        requestPageNumber.setAlignment("center");
        requestPageNumber.setFormat("{PAGE} of {NUMPAGES}");
        requestPageNumber.setIsTop(Boolean.valueOf(true));
        requestPageNumber.setSetPageNumberOnFirstPage(Boolean.valueOf(true));
        InsertPageNumbersRequest request = new InsertPageNumbersRequest(remoteFileName, requestPageNumber, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        DocumentResponse result = TestInitializer.wordsApi.insertPageNumbers(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getDocument());
        TestField.assertEquals((String)"TestInsertPageNumbers.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testInsertPageNumbersOnline() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "Common/" + localFileName).toAbsolutePath());
        PageNumber requestPageNumber = new PageNumber();
        requestPageNumber.setAlignment("center");
        requestPageNumber.setFormat("{PAGE} of {NUMPAGES}");
        requestPageNumber.setIsTop(Boolean.valueOf(true));
        requestPageNumber.setSetPageNumberOnFirstPage(Boolean.valueOf(true));
        InsertPageNumbersOnlineRequest request = new InsertPageNumbersOnlineRequest(requestDocument, requestPageNumber, null, null, null, null, null, null, null);
        InsertPageNumbersOnlineResponse result = TestInitializer.wordsApi.insertPageNumbersOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteField() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestDeleteField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldRequest request = new DeleteFieldRequest(remoteFileName, Integer.valueOf(0), "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteField(request);
    }

    @Test
    public void testDeleteFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/GetField.docx").toAbsolutePath());
        DeleteFieldOnlineRequest request = new DeleteFieldOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0/paragraphs/0", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteFieldOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "GetField.docx";
        String remoteFileName = "TestDeleteFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldRequest request = new DeleteFieldRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteField(request);
    }

    @Test
    public void testDeleteParagraphFields() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteParagraphFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, "paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteParagraphFieldsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteParagraphFieldsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteSectionFields() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteSectionFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, "sections/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteSectionFieldsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteSectionFieldsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteSectionParagraphFields() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteSectionParagraphFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteDocumentFields() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestDeleteSectionParagraphFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFieldsRequest request = new DeleteFieldsRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteFields(request);
    }

    @Test
    public void testDeleteDocumentFieldsOnline() throws ApiException, MessagingException, IOException {
        String localFileName = "Common/test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, localFileName).toAbsolutePath());
        DeleteFieldsOnlineRequest request = new DeleteFieldsOnlineRequest(requestDocument, "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteFieldsOnline(request);
        TestField.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateDocumentFields() throws ApiException, MessagingException, IOException {
        String localFileName = "test_multi_pages.docx";
        String remoteFileName = "TestUpdateDocumentFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/" + localFileName), this.remoteDataFolder + "/" + remoteFileName);
        UpdateFieldsRequest request = new UpdateFieldsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.updateFields(request);
        TestField.assertNotNull((Object)result);
        TestField.assertNotNull((Object)result.getDocument());
        TestField.assertEquals((String)"TestUpdateDocumentFields.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testUpdateDocumentFieldsOnline() throws ApiException, MessagingException, IOException {
        String localFile = "Common/test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, localFile).toAbsolutePath());
        UpdateFieldsOnlineRequest request = new UpdateFieldsOnlineRequest(requestDocument, null, null, null, null, null);
        UpdateFieldsOnlineResponse result = TestInitializer.wordsApi.updateFieldsOnline(request);
        TestField.assertNotNull((Object)result);
    }
}

