/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.field;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.FormField;
import com.aspose.words.cloud.model.FormFieldResponse;
import com.aspose.words.cloud.model.FormFieldTextInput;
import com.aspose.words.cloud.model.FormFieldsResponse;
import com.aspose.words.cloud.model.requests.DeleteFormFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteFormFieldRequest;
import com.aspose.words.cloud.model.requests.GetFormFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFormFieldRequest;
import com.aspose.words.cloud.model.requests.GetFormFieldsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetFormFieldsRequest;
import com.aspose.words.cloud.model.requests.InsertFormFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertFormFieldRequest;
import com.aspose.words.cloud.model.requests.UpdateFormFieldOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateFormFieldRequest;
import com.aspose.words.cloud.model.responses.InsertFormFieldOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateFormFieldOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestFormField
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/FormFields";
    private String fieldFolder = "DocumentElements/FormFields";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testUpdateFormField() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateFormField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("No name");
        requestFormField.setTextInputFormat("");
        UpdateFormFieldRequest request = new UpdateFormFieldRequest(remoteFileName, Integer.valueOf(0), (FormField)requestFormField, "sections/0", this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.updateFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
        TestFormField.assertEquals((String)"", (String)result.getFormField().getStatusText());
    }

    @Test
    public void testUpdateFormFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx").toAbsolutePath());
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("No name");
        requestFormField.setTextInputFormat("");
        UpdateFormFieldOnlineRequest request = new UpdateFormFieldOnlineRequest(requestDocument, (FormField)requestFormField, Integer.valueOf(0), "sections/0", null, null, null, null, null, null, null);
        UpdateFormFieldOnlineResponse result = TestInitializer.wordsApi.updateFormFieldOnline(request);
        TestFormField.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateFormFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateFormFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("No name");
        requestFormField.setTextInputFormat("");
        UpdateFormFieldRequest request = new UpdateFormFieldRequest(remoteFileName, Integer.valueOf(0), (FormField)requestFormField, null, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.updateFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
        TestFormField.assertEquals((String)"", (String)result.getFormField().getStatusText());
    }

    @Test
    public void testGetFormField() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFormField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetFormFieldRequest request = new GetFormFieldRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.getFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
    }

    @Test
    public void testGetFormFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx").toAbsolutePath());
        GetFormFieldOnlineRequest request = new GetFormFieldOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.getFormFieldOnline(request);
        TestFormField.assertNotNull((Object)result);
    }

    @Test
    public void testGetFormFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFormFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetFormFieldRequest request = new GetFormFieldRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.getFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
    }

    @Test
    public void testGetFormFields() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFormFields.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetFormFieldsRequest request = new GetFormFieldsRequest(remoteFileName, "sections/0", this.remoteDataFolder, null, null, null, null, null);
        FormFieldsResponse result = TestInitializer.wordsApi.getFormFields(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormFields());
        TestFormField.assertNotNull((Object)result.getFormFields().getList());
        TestFormField.assertEquals((int)5, (int)result.getFormFields().getList().size());
        TestFormField.assertEquals((String)"FullName", (String)((FormField)result.getFormFields().getList().get(0)).getName());
    }

    @Test
    public void testGetFormFieldsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx").toAbsolutePath());
        GetFormFieldsOnlineRequest request = new GetFormFieldsOnlineRequest(requestDocument, "sections/0", null, null, null, null);
        FormFieldsResponse result = TestInitializer.wordsApi.getFormFieldsOnline(request);
        TestFormField.assertNotNull((Object)result);
    }

    @Test
    public void testGetFormFieldsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetFormFieldsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetFormFieldsRequest request = new GetFormFieldsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        FormFieldsResponse result = TestInitializer.wordsApi.getFormFields(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormFields());
        TestFormField.assertNotNull((Object)result.getFormFields().getList());
        TestFormField.assertEquals((int)5, (int)result.getFormFields().getList().size());
        TestFormField.assertEquals((String)"FullName", (String)((FormField)result.getFormFields().getList().get(0)).getName());
    }

    @Test
    public void testInsertFormField() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertFormField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/test_multi_pages.docx"), this.remoteDataFolder + "/" + remoteFileName);
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("123");
        requestFormField.setTextInputFormat("UPPERCASE");
        InsertFormFieldRequest request = new InsertFormFieldRequest(remoteFileName, (FormField)requestFormField, "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.insertFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
        TestFormField.assertEquals((String)"", (String)result.getFormField().getStatusText());
    }

    @Test
    public void testInsertFormFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx").toAbsolutePath());
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("123");
        requestFormField.setTextInputFormat("UPPERCASE");
        InsertFormFieldOnlineRequest request = new InsertFormFieldOnlineRequest(requestDocument, (FormField)requestFormField, "sections/0/paragraphs/0", null, null, null, null, null, null, null, null);
        InsertFormFieldOnlineResponse result = TestInitializer.wordsApi.insertFormFieldOnline(request);
        TestFormField.assertNotNull((Object)result);
    }

    @Test
    public void testInsertFormFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertFormFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "Common/test_multi_pages.docx"), this.remoteDataFolder + "/" + remoteFileName);
        FormFieldTextInput requestFormField = new FormFieldTextInput();
        requestFormField.setName("FullName");
        requestFormField.setEnabled(Boolean.valueOf(true));
        requestFormField.setCalculateOnExit(Boolean.valueOf(true));
        requestFormField.setStatusText("");
        requestFormField.setTextInputType(FormFieldTextInput.TextInputTypeEnum.REGULAR);
        requestFormField.setTextInputDefault("123");
        requestFormField.setTextInputFormat("UPPERCASE");
        InsertFormFieldRequest request = new InsertFormFieldRequest(remoteFileName, (FormField)requestFormField, null, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null, null);
        FormFieldResponse result = TestInitializer.wordsApi.insertFormField(request);
        TestFormField.assertNotNull((Object)result);
        TestFormField.assertNotNull((Object)result.getFormField());
        TestFormField.assertEquals((String)"FullName", (String)result.getFormField().getName());
        TestFormField.assertEquals((String)"", (String)result.getFormField().getStatusText());
    }

    @Test
    public void testDeleteFormField() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteFormField.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFormFieldRequest request = new DeleteFormFieldRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteFormField(request);
    }

    @Test
    public void testDeleteFormFieldOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx").toAbsolutePath());
        DeleteFormFieldOnlineRequest request = new DeleteFormFieldOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteFormFieldOnline(request);
        TestFormField.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteFormFieldWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteFormFieldWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.fieldFolder + "/FormFilled.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFormFieldRequest request = new DeleteFormFieldRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteFormField(request);
    }
}

