/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.mailMerge;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeOnlineRequest;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestExecuteMailMerge
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/MailMerge";
    private String mailMergeFolder = "DocumentActions/MailMerge";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testExecuteMailMergeOnline() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "SampleExecuteTemplate.docx";
        String localDataFile = "SampleExecuteTemplateData.txt";
        byte[] requestTemplate = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile).toAbsolutePath());
        byte[] requestData = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDataFile).toAbsolutePath());
        ExecuteMailMergeOnlineRequest request = new ExecuteMailMergeOnlineRequest(requestTemplate, requestData, null, Boolean.valueOf(true), null, null, null);
        byte[] result = TestInitializer.wordsApi.executeMailMergeOnline(request);
        TestExecuteMailMerge.assertNotNull((Object)result);
    }

    @Test
    public void testExecuteMailMerge() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "SampleExecuteTemplate.docx";
        String remoteFileName = "TestExecuteMailMerge.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/SampleMailMergeTemplateData.txt")), "utf8");
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile), this.remoteDataFolder + "/" + remoteFileName);
        ExecuteMailMergeRequest request = new ExecuteMailMergeRequest(remoteFileName, localDataFile, null, this.remoteDataFolder, null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        DocumentResponse result = TestInitializer.wordsApi.executeMailMerge(request);
        TestExecuteMailMerge.assertNotNull((Object)result);
        TestExecuteMailMerge.assertNotNull((Object)result.getDocument());
        TestExecuteMailMerge.assertEquals((String)"TestExecuteMailMerge.docx", (String)result.getDocument().getFileName());
    }
}

