/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.paragraph;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Font;
import com.aspose.words.cloud.model.FontResponse;
import com.aspose.words.cloud.model.ListFormatUpdate;
import com.aspose.words.cloud.model.ParagraphFormatBase;
import com.aspose.words.cloud.model.ParagraphFormatResponse;
import com.aspose.words.cloud.model.ParagraphFormatUpdate;
import com.aspose.words.cloud.model.ParagraphInsert;
import com.aspose.words.cloud.model.ParagraphLink;
import com.aspose.words.cloud.model.ParagraphLinkCollectionResponse;
import com.aspose.words.cloud.model.ParagraphListFormatResponse;
import com.aspose.words.cloud.model.ParagraphResponse;
import com.aspose.words.cloud.model.Run;
import com.aspose.words.cloud.model.RunResponse;
import com.aspose.words.cloud.model.RunsResponse;
import com.aspose.words.cloud.model.TabStop;
import com.aspose.words.cloud.model.TabStopBase;
import com.aspose.words.cloud.model.TabStopInsert;
import com.aspose.words.cloud.model.TabStopsResponse;
import com.aspose.words.cloud.model.requests.DeleteAllParagraphTabStopsOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteAllParagraphTabStopsRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphListFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphListFormatRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphTabStopOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteParagraphTabStopRequest;
import com.aspose.words.cloud.model.requests.GetParagraphFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.GetParagraphFormatRequest;
import com.aspose.words.cloud.model.requests.GetParagraphListFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.GetParagraphListFormatRequest;
import com.aspose.words.cloud.model.requests.GetParagraphOnlineRequest;
import com.aspose.words.cloud.model.requests.GetParagraphRequest;
import com.aspose.words.cloud.model.requests.GetParagraphTabStopsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetParagraphTabStopsRequest;
import com.aspose.words.cloud.model.requests.GetParagraphsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetParagraphsRequest;
import com.aspose.words.cloud.model.requests.GetRunFontOnlineRequest;
import com.aspose.words.cloud.model.requests.GetRunFontRequest;
import com.aspose.words.cloud.model.requests.GetRunOnlineRequest;
import com.aspose.words.cloud.model.requests.GetRunRequest;
import com.aspose.words.cloud.model.requests.GetRunsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetRunsRequest;
import com.aspose.words.cloud.model.requests.InsertOrUpdateParagraphTabStopOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertOrUpdateParagraphTabStopRequest;
import com.aspose.words.cloud.model.requests.InsertParagraphOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertParagraphRequest;
import com.aspose.words.cloud.model.requests.RenderParagraphOnlineRequest;
import com.aspose.words.cloud.model.requests.RenderParagraphRequest;
import com.aspose.words.cloud.model.requests.UpdateParagraphFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateParagraphFormatRequest;
import com.aspose.words.cloud.model.requests.UpdateParagraphListFormatOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateParagraphListFormatRequest;
import com.aspose.words.cloud.model.requests.UpdateRunFontOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateRunFontRequest;
import com.aspose.words.cloud.model.responses.DeleteAllParagraphTabStopsOnlineResponse;
import com.aspose.words.cloud.model.responses.DeleteParagraphListFormatOnlineResponse;
import com.aspose.words.cloud.model.responses.DeleteParagraphTabStopOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertOrUpdateParagraphTabStopOnlineResponse;
import com.aspose.words.cloud.model.responses.InsertParagraphOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateParagraphFormatOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateParagraphListFormatOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateRunFontOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestParagraph
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Paragraphs";
    private String localFile = "Common/test_multi_pages.docx";
    private String listFolder = "DocumentElements/ParagraphListFormat";
    private String tabStopFolder = "DocumentElements/Paragraphs";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentParagraphByIndex() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphByIndex.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphRequest request = new GetParagraphRequest(remoteFileName, Integer.valueOf(0), "sections/0", this.remoteDataFolder, null, null, null, null, null);
        ParagraphResponse result = TestInitializer.wordsApi.getParagraph(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraph());
        TestParagraph.assertEquals((String)"0.0.0", (String)result.getParagraph().getNodeId());
    }

    @Test
    public void testGetDocumentParagraphOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetParagraphOnlineRequest request = new GetParagraphOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0", null, null, null, null);
        ParagraphResponse result = TestInitializer.wordsApi.getParagraphOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentParagraphByIndexWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphByIndexWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphRequest request = new GetParagraphRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        ParagraphResponse result = TestInitializer.wordsApi.getParagraph(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraph());
        TestParagraph.assertEquals((String)"0.0.0", (String)result.getParagraph().getNodeId());
    }

    @Test
    public void testGetDocumentParagraphs() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphs.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphsRequest request = new GetParagraphsRequest(remoteFileName, "sections/0", this.remoteDataFolder, null, null, null, null, null);
        ParagraphLinkCollectionResponse result = TestInitializer.wordsApi.getParagraphs(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraphs());
        TestParagraph.assertNotNull((Object)result.getParagraphs().getParagraphLinkList());
        TestParagraph.assertEquals((int)15, (int)result.getParagraphs().getParagraphLinkList().size());
        TestParagraph.assertEquals((String)"Page 1 of 3", (String)((ParagraphLink)result.getParagraphs().getParagraphLinkList().get(0)).getText());
    }

    @Test
    public void testGetDocumentParagraphsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetParagraphsOnlineRequest request = new GetParagraphsOnlineRequest(requestDocument, "sections/0", null, null, null, null);
        ParagraphLinkCollectionResponse result = TestInitializer.wordsApi.getParagraphsOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentParagraphsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphsRequest request = new GetParagraphsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        ParagraphLinkCollectionResponse result = TestInitializer.wordsApi.getParagraphs(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraphs());
        TestParagraph.assertNotNull((Object)result.getParagraphs().getParagraphLinkList());
        TestParagraph.assertEquals((int)15, (int)result.getParagraphs().getParagraphLinkList().size());
        TestParagraph.assertEquals((String)"Page 1 of 3", (String)((ParagraphLink)result.getParagraphs().getParagraphLinkList().get(0)).getText());
    }

    @Test
    public void testGetDocumentParagraphRun() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphRun.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetRunRequest request = new GetRunRequest(remoteFileName, "paragraphs/0", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        RunResponse result = TestInitializer.wordsApi.getRun(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getRun());
        TestParagraph.assertEquals((String)"Page ", (String)result.getRun().getText());
    }

    @Test
    public void testGetDocumentParagraphRunOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetRunOnlineRequest request = new GetRunOnlineRequest(requestDocument, "paragraphs/0", Integer.valueOf(0), null, null, null, null);
        RunResponse result = TestInitializer.wordsApi.getRunOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentParagraphRunFont() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphRunFont.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetRunFontRequest request = new GetRunFontRequest(remoteFileName, "paragraphs/0", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        FontResponse result = TestInitializer.wordsApi.getRunFont(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getFont());
        TestParagraph.assertEquals((String)"Times New Roman", (String)result.getFont().getName());
    }

    @Test
    public void testGetDocumentParagraphRunFontOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetRunFontOnlineRequest request = new GetRunFontOnlineRequest(requestDocument, "paragraphs/0", Integer.valueOf(0), null, null, null, null);
        FontResponse result = TestInitializer.wordsApi.getRunFontOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphRuns() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetParagraphRuns.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetRunsRequest request = new GetRunsRequest(remoteFileName, "sections/0/paragraphs/0", this.remoteDataFolder, null, null, null, null, null);
        RunsResponse result = TestInitializer.wordsApi.getRuns(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getRuns());
        TestParagraph.assertNotNull((Object)result.getRuns().getList());
        TestParagraph.assertEquals((int)6, (int)result.getRuns().getList().size());
        TestParagraph.assertEquals((String)"Page ", (String)((Run)result.getRuns().getList().get(0)).getText());
    }

    @Test
    public void testGetParagraphRunsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetRunsOnlineRequest request = new GetRunsOnlineRequest(requestDocument, "sections/0/paragraphs/0", null, null, null, null);
        RunsResponse result = TestInitializer.wordsApi.getRunsOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateRunFont() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateRunFont.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        Font requestFontDto = new Font();
        requestFontDto.setBold(Boolean.valueOf(true));
        UpdateRunFontRequest request = new UpdateRunFontRequest(remoteFileName, "paragraphs/0", Integer.valueOf(0), requestFontDto, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        FontResponse result = TestInitializer.wordsApi.updateRunFont(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getFont());
        TestParagraph.assertEquals((Object)true, (Object)result.getFont().getBold());
    }

    @Test
    public void testUpdateRunFontOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        Font requestFontDto = new Font();
        requestFontDto.setBold(Boolean.valueOf(true));
        UpdateRunFontOnlineRequest request = new UpdateRunFontOnlineRequest(requestDocument, "paragraphs/0", requestFontDto, Integer.valueOf(0), null, null, null, null, null, null, null);
        UpdateRunFontOnlineResponse result = TestInitializer.wordsApi.updateRunFontOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testInsertParagraph() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertParagraph.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ParagraphInsert requestParagraph = new ParagraphInsert();
        requestParagraph.setText("This is a new paragraph for your document");
        InsertParagraphRequest request = new InsertParagraphRequest(remoteFileName, requestParagraph, "sections/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphResponse result = TestInitializer.wordsApi.insertParagraph(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraph());
        TestParagraph.assertEquals((String)"0.3.8", (String)result.getParagraph().getNodeId());
    }

    @Test
    public void testInsertParagraphOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ParagraphInsert requestParagraph = new ParagraphInsert();
        requestParagraph.setText("This is a new paragraph for your document");
        InsertParagraphOnlineRequest request = new InsertParagraphOnlineRequest(requestDocument, requestParagraph, "sections/0", null, null, null, null, null, null, null);
        InsertParagraphOnlineResponse result = TestInitializer.wordsApi.insertParagraphOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testInsertParagraphWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertParagraphWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ParagraphInsert requestParagraph = new ParagraphInsert();
        requestParagraph.setText("This is a new paragraph for your document");
        InsertParagraphRequest request = new InsertParagraphRequest(remoteFileName, requestParagraph, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphResponse result = TestInitializer.wordsApi.insertParagraph(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraph());
        TestParagraph.assertEquals((String)"0.3.8", (String)result.getParagraph().getNodeId());
    }

    @Test
    public void testRenderParagraph() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderParagraph.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderParagraphRequest request = new RenderParagraphRequest(remoteFileName, "png", Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderParagraph(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testRenderParagraphOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RenderParagraphOnlineRequest request = new RenderParagraphOnlineRequest(requestDocument, "png", Integer.valueOf(0), "", null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderParagraphOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testRenderParagraphWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderParagraphWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderParagraphRequest request = new RenderParagraphRequest(remoteFileName, "png", Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderParagraph(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphs.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphFormatRequest request = new GetParagraphFormatRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null);
        ParagraphFormatResponse result = TestInitializer.wordsApi.getParagraphFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraphFormat());
        TestParagraph.assertEquals((String)"Normal", (String)result.getParagraphFormat().getStyleName());
    }

    @Test
    public void testGetParagraphFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetParagraphFormatOnlineRequest request = new GetParagraphFormatOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null);
        ParagraphFormatResponse result = TestInitializer.wordsApi.getParagraphFormatOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphFormatWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphFormatRequest request = new GetParagraphFormatRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        ParagraphFormatResponse result = TestInitializer.wordsApi.getParagraphFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraphFormat());
        TestParagraph.assertEquals((String)"Normal", (String)result.getParagraphFormat().getStyleName());
    }

    @Test
    public void testUpdateParagraphFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentParagraphs.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ParagraphFormatUpdate requestParagraphFormatDto = new ParagraphFormatUpdate();
        requestParagraphFormatDto.setAlignment(ParagraphFormatBase.AlignmentEnum.RIGHT);
        UpdateParagraphFormatRequest request = new UpdateParagraphFormatRequest(remoteFileName, Integer.valueOf(0), requestParagraphFormatDto, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphFormatResponse result = TestInitializer.wordsApi.updateParagraphFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getParagraphFormat());
    }

    @Test
    public void testUpdateParagraphFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ParagraphFormatUpdate requestParagraphFormatDto = new ParagraphFormatUpdate();
        requestParagraphFormatDto.setAlignment(ParagraphFormatBase.AlignmentEnum.RIGHT);
        UpdateParagraphFormatOnlineRequest request = new UpdateParagraphFormatOnlineRequest(requestDocument, requestParagraphFormatDto, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        UpdateParagraphFormatOnlineResponse result = TestInitializer.wordsApi.updateParagraphFormatOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteParagraph() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraph.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphRequest request = new DeleteParagraphRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteParagraph(request);
    }

    @Test
    public void testDeleteParagraphOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteParagraphOnlineRequest request = new DeleteParagraphOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteParagraphOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteParagraphWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraphWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphRequest request = new DeleteParagraphRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteParagraph(request);
    }

    @Test
    public void testGetParagraphListFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestParagraphGetListFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphGetListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphListFormatRequest request = new GetParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.getParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getListFormat());
        TestParagraph.assertEquals((Object)1, (Object)result.getListFormat().getListId());
    }

    @Test
    public void testGetParagraphListFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphGetListFormat.doc").toAbsolutePath());
        GetParagraphListFormatOnlineRequest request = new GetParagraphListFormatOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.getParagraphListFormatOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphListFormatWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestParagraphGetListFormatWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphGetListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphListFormatRequest request = new GetParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.getParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getListFormat());
        TestParagraph.assertEquals((Object)1, (Object)result.getListFormat().getListId());
    }

    @Test
    public void testUpdateParagraphListFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateParagraphListFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphUpdateListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        ListFormatUpdate requestListFormatDto = new ListFormatUpdate();
        requestListFormatDto.setListId(Integer.valueOf(2));
        UpdateParagraphListFormatRequest request = new UpdateParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), requestListFormatDto, "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.updateParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getListFormat());
        TestParagraph.assertEquals((Object)2, (Object)result.getListFormat().getListId());
    }

    @Test
    public void testUpdateParagraphListFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphUpdateListFormat.doc").toAbsolutePath());
        ListFormatUpdate requestListFormatDto = new ListFormatUpdate();
        requestListFormatDto.setListId(Integer.valueOf(2));
        UpdateParagraphListFormatOnlineRequest request = new UpdateParagraphListFormatOnlineRequest(requestDocument, requestListFormatDto, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        UpdateParagraphListFormatOnlineResponse result = TestInitializer.wordsApi.updateParagraphListFormatOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateParagraphListFormatWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateParagraphListFormatWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphUpdateListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        ListFormatUpdate requestListFormatDto = new ListFormatUpdate();
        requestListFormatDto.setListId(Integer.valueOf(2));
        UpdateParagraphListFormatRequest request = new UpdateParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), requestListFormatDto, null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.updateParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getListFormat());
        TestParagraph.assertEquals((Object)2, (Object)result.getListFormat().getListId());
    }

    @Test
    public void testDeleteParagraphListFormat() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraphListFormat.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphDeleteListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphListFormatRequest request = new DeleteParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.deleteParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteParagraphListFormatOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphDeleteListFormat.doc").toAbsolutePath());
        DeleteParagraphListFormatOnlineRequest request = new DeleteParagraphListFormatOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        DeleteParagraphListFormatOnlineResponse result = TestInitializer.wordsApi.deleteParagraphListFormatOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteParagraphListFormatWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraphListFormatWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.listFolder + "/ParagraphDeleteListFormat.doc"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphListFormatRequest request = new DeleteParagraphListFormatRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ParagraphListFormatResponse result = TestInitializer.wordsApi.deleteParagraphListFormat(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphTabStops() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetParagraphTabStops.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphTabStopsRequest request = new GetParagraphTabStopsRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.getParagraphTabStops(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)2, (int)result.getTabStops().size());
        TestParagraph.assertEquals((Object)72.0, (Object)((TabStop)result.getTabStops().get(0)).getPosition());
    }

    @Test
    public void testGetParagraphTabStopsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx").toAbsolutePath());
        GetParagraphTabStopsOnlineRequest request = new GetParagraphTabStopsOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.getParagraphTabStopsOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testGetParagraphTabStopsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetParagraphTabStopsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        GetParagraphTabStopsRequest request = new GetParagraphTabStopsRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.getParagraphTabStops(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)2, (int)result.getTabStops().size());
        TestParagraph.assertEquals((Object)72.0, (Object)((TabStop)result.getTabStops().get(0)).getPosition());
    }

    @Test
    public void testInsertParagraphTabStops() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertOrUpdateParagraphTabStop.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        TabStopInsert requestTabStopInsertDto = new TabStopInsert();
        requestTabStopInsertDto.setAlignment(TabStopBase.AlignmentEnum.LEFT);
        requestTabStopInsertDto.setLeader(TabStopBase.LeaderEnum.NONE);
        requestTabStopInsertDto.setPosition(Double.valueOf(100.0));
        InsertOrUpdateParagraphTabStopRequest request = new InsertOrUpdateParagraphTabStopRequest(remoteFileName, Integer.valueOf(0), requestTabStopInsertDto, "", this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.insertOrUpdateParagraphTabStop(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)3, (int)result.getTabStops().size());
        TestParagraph.assertEquals((Object)100.0, (Object)((TabStop)result.getTabStops().get(1)).getPosition());
    }

    @Test
    public void testInsertParagraphTabStopsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx").toAbsolutePath());
        TabStopInsert requestTabStopInsertDto = new TabStopInsert();
        requestTabStopInsertDto.setAlignment(TabStopBase.AlignmentEnum.LEFT);
        requestTabStopInsertDto.setLeader(TabStopBase.LeaderEnum.NONE);
        requestTabStopInsertDto.setPosition(Double.valueOf(72.0));
        InsertOrUpdateParagraphTabStopOnlineRequest request = new InsertOrUpdateParagraphTabStopOnlineRequest(requestDocument, requestTabStopInsertDto, Integer.valueOf(0), "", null, null, null, null, null);
        InsertOrUpdateParagraphTabStopOnlineResponse result = TestInitializer.wordsApi.insertOrUpdateParagraphTabStopOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testInsertParagraphTabStopsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertOrUpdateParagraphTabStopWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        TabStopInsert requestTabStopInsertDto = new TabStopInsert();
        requestTabStopInsertDto.setAlignment(TabStopBase.AlignmentEnum.LEFT);
        requestTabStopInsertDto.setLeader(TabStopBase.LeaderEnum.NONE);
        requestTabStopInsertDto.setPosition(Double.valueOf(100.0));
        InsertOrUpdateParagraphTabStopRequest request = new InsertOrUpdateParagraphTabStopRequest(remoteFileName, Integer.valueOf(0), requestTabStopInsertDto, null, this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.insertOrUpdateParagraphTabStop(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)3, (int)result.getTabStops().size());
        TestParagraph.assertEquals((Object)100.0, (Object)((TabStop)result.getTabStops().get(1)).getPosition());
    }

    @Test
    public void testDeleteAllParagraphTabStops() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteAllParagraphTabStops.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteAllParagraphTabStopsRequest request = new DeleteAllParagraphTabStopsRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.deleteAllParagraphTabStops(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)0, (int)result.getTabStops().size());
    }

    @Test
    public void testDeleteAllParagraphTabStopsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx").toAbsolutePath());
        DeleteAllParagraphTabStopsOnlineRequest request = new DeleteAllParagraphTabStopsOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null);
        DeleteAllParagraphTabStopsOnlineResponse result = TestInitializer.wordsApi.deleteAllParagraphTabStopsOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteAllParagraphTabStopsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteAllParagraphTabStopsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteAllParagraphTabStopsRequest request = new DeleteAllParagraphTabStopsRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.deleteAllParagraphTabStops(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)0, (int)result.getTabStops().size());
    }

    @Test
    public void testDeleteParagraphTabStop() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraphTabStop.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphTabStopRequest request = new DeleteParagraphTabStopRequest(remoteFileName, Double.valueOf(72.0), Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.deleteParagraphTabStop(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)1, (int)result.getTabStops().size());
    }

    @Test
    public void testDeleteParagraphTabStopOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx").toAbsolutePath());
        DeleteParagraphTabStopOnlineRequest request = new DeleteParagraphTabStopOnlineRequest(requestDocument, Double.valueOf(72.0), Integer.valueOf(0), "", null, null, null, null, null);
        DeleteParagraphTabStopOnlineResponse result = TestInitializer.wordsApi.deleteParagraphTabStopOnline(request);
        TestParagraph.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteParagraphTabStopWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteParagraphTabStopWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.tabStopFolder + "/ParagraphTabStops.docx"), this.remoteDataFolder + "/" + remoteFileName);
        DeleteParagraphTabStopRequest request = new DeleteParagraphTabStopRequest(remoteFileName, Double.valueOf(72.0), Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null);
        TabStopsResponse result = TestInitializer.wordsApi.deleteParagraphTabStop(request);
        TestParagraph.assertNotNull((Object)result);
        TestParagraph.assertNotNull((Object)result.getTabStops());
        TestParagraph.assertEquals((int)1, (int)result.getTabStops().size());
    }
}

