/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.range;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.RangeDocument;
import com.aspose.words.cloud.model.RangeTextResponse;
import com.aspose.words.cloud.model.ReplaceRange;
import com.aspose.words.cloud.model.TranslateNodeIdResponse;
import com.aspose.words.cloud.model.requests.GetRangeTextOnlineRequest;
import com.aspose.words.cloud.model.requests.GetRangeTextRequest;
import com.aspose.words.cloud.model.requests.RemoveRangeOnlineRequest;
import com.aspose.words.cloud.model.requests.RemoveRangeRequest;
import com.aspose.words.cloud.model.requests.ReplaceWithTextOnlineRequest;
import com.aspose.words.cloud.model.requests.ReplaceWithTextRequest;
import com.aspose.words.cloud.model.requests.SaveAsRangeOnlineRequest;
import com.aspose.words.cloud.model.requests.SaveAsRangeRequest;
import com.aspose.words.cloud.model.requests.TranslateNodeIdOnlineRequest;
import com.aspose.words.cloud.model.requests.TranslateNodeIdRequest;
import com.aspose.words.cloud.model.responses.RemoveRangeOnlineResponse;
import com.aspose.words.cloud.model.responses.ReplaceWithTextOnlineResponse;
import com.aspose.words.cloud.model.responses.SaveAsRangeOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestRange
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Range";
    private String localFile = "DocumentElements/Range/RangeGet.doc";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetRangeText() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetRangeText.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetRangeTextRequest request = new GetRangeTextRequest(remoteFileName, "id0.0.0", "id0.0.1", this.remoteDataFolder, null, null, null, null, null);
        RangeTextResponse result = TestInitializer.wordsApi.getRangeText(request);
        TestRange.assertNotNull((Object)result);
        TestRange.assertEquals((String)"This is HEADER ", (String)result.getText());
    }

    @Test
    public void testGetRangeTextOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetRangeTextOnlineRequest request = new GetRangeTextOnlineRequest(requestDocument, "id0.0.0", "id0.0.1", null, null, null, null);
        RangeTextResponse result = TestInitializer.wordsApi.getRangeTextOnline(request);
        TestRange.assertNotNull((Object)result);
    }

    @Test
    public void testRemoveRange() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRemoveRange.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RemoveRangeRequest request = new RemoveRangeRequest(remoteFileName, "id0.0.0", "id0.0.1", this.remoteDataFolder, null, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.removeRange(request);
        TestRange.assertNotNull((Object)result);
    }

    @Test
    public void testRemoveRangeOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RemoveRangeOnlineRequest request = new RemoveRangeOnlineRequest(requestDocument, "id0.0.0", "id0.0.1", null, null, null, null, null);
        RemoveRangeOnlineResponse result = TestInitializer.wordsApi.removeRangeOnline(request);
        TestRange.assertNotNull((Object)result);
    }

    @Test
    public void testSaveAsRange() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestSaveAsRange.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RangeDocument requestDocumentParameters = new RangeDocument();
        requestDocumentParameters.setDocumentName(this.remoteDataFolder + "/NewDoc.docx");
        SaveAsRangeRequest request = new SaveAsRangeRequest(remoteFileName, "id0.0.0", requestDocumentParameters, "id0.0.1", this.remoteDataFolder, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.saveAsRange(request);
        TestRange.assertNotNull((Object)result);
        TestRange.assertNotNull((Object)result.getDocument());
        TestRange.assertEquals((String)"NewDoc.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testSaveAsRangeOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RangeDocument requestDocumentParameters = new RangeDocument();
        requestDocumentParameters.setDocumentName(this.remoteDataFolder + "/NewDoc.docx");
        SaveAsRangeOnlineRequest request = new SaveAsRangeOnlineRequest(requestDocument, "id0.0.0", requestDocumentParameters, "id0.0.1", null, null, null, null);
        SaveAsRangeOnlineResponse result = TestInitializer.wordsApi.saveAsRangeOnline(request);
        TestRange.assertNotNull((Object)result);
    }

    @Test
    public void testReplaceWithText() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestReplaceWithText.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ReplaceRange requestRangeText = new ReplaceRange();
        requestRangeText.setText("Replaced header");
        ReplaceWithTextRequest request = new ReplaceWithTextRequest(remoteFileName, "id0.0.0", requestRangeText, "id0.0.1", this.remoteDataFolder, null, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.replaceWithText(request);
        TestRange.assertNotNull((Object)result);
        TestRange.assertNotNull((Object)result.getDocument());
        TestRange.assertEquals((String)"TestReplaceWithText.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testReplaceWithTextOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ReplaceRange requestRangeText = new ReplaceRange();
        requestRangeText.setText("Replaced header");
        ReplaceWithTextOnlineRequest request = new ReplaceWithTextOnlineRequest(requestDocument, "id0.0.0", requestRangeText, "id0.0.1", null, null, null, null, null);
        ReplaceWithTextOnlineResponse result = TestInitializer.wordsApi.replaceWithTextOnline(request);
        TestRange.assertNotNull((Object)result);
    }

    @Test
    public void testTranslateNodeId() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestTranslateNodeId.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        TranslateNodeIdRequest request = new TranslateNodeIdRequest(remoteFileName, "id0.0.0", this.remoteDataFolder, null, null, null, null, null);
        TranslateNodeIdResponse result = TestInitializer.wordsApi.translateNodeId(request);
        TestRange.assertNotNull((Object)result);
        TestRange.assertEquals((String)"sections/0/body/paragraphs/0", (String)result.getPath());
    }

    @Test
    public void testTranslateNodeIdOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        TranslateNodeIdOnlineRequest request = new TranslateNodeIdOnlineRequest(requestDocument, "id0.0.0", null, null, null, null);
        TranslateNodeIdResponse result = TestInitializer.wordsApi.translateNodeIdOnline(request);
        TestRange.assertNotNull((Object)result);
    }
}

