/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.sections;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.NodeLink;
import com.aspose.words.cloud.model.SectionLink;
import com.aspose.words.cloud.model.SectionLinkCollectionResponse;
import com.aspose.words.cloud.model.SectionResponse;
import com.aspose.words.cloud.model.requests.DeleteSectionOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteSectionRequest;
import com.aspose.words.cloud.model.requests.GetSectionOnlineRequest;
import com.aspose.words.cloud.model.requests.GetSectionRequest;
import com.aspose.words.cloud.model.requests.GetSectionsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetSectionsRequest;
import com.aspose.words.cloud.model.requests.InsertSectionOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertSectionRequest;
import com.aspose.words.cloud.model.requests.LinkHeaderFootersToPreviousRequest;
import com.aspose.words.cloud.model.requests.MergeWithNextOnlineRequest;
import com.aspose.words.cloud.model.requests.MergeWithNextRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestSection
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Section";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetSection() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetSection.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetSectionRequest request = new GetSectionRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        SectionResponse result = TestInitializer.wordsApi.getSection(request);
        TestSection.assertNotNull((Object)result);
        TestSection.assertNotNull((Object)result.getSection());
        TestSection.assertNotNull((Object)result.getSection().getChildNodes());
        TestSection.assertEquals((int)13, (int)result.getSection().getChildNodes().size());
        TestSection.assertEquals((String)"0.3.0", (String)((NodeLink)result.getSection().getChildNodes().get(0)).getNodeId());
    }

    @Test
    public void testGetSectionOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetSectionOnlineRequest request = new GetSectionOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null);
        SectionResponse result = TestInitializer.wordsApi.getSectionOnline(request);
        TestSection.assertNotNull((Object)result);
    }

    @Test
    public void testGetSections() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetSections.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetSectionsRequest request = new GetSectionsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        SectionLinkCollectionResponse result = TestInitializer.wordsApi.getSections(request);
        TestSection.assertNotNull((Object)result);
        TestSection.assertNotNull((Object)result.getSections());
        TestSection.assertNotNull((Object)result.getSections().getSectionLinkList());
        TestSection.assertEquals((int)1, (int)result.getSections().getSectionLinkList().size());
        TestSection.assertEquals((String)"0", (String)((SectionLink)result.getSections().getSectionLinkList().get(0)).getNodeId());
    }

    @Test
    public void testGetSectionsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetSectionsOnlineRequest request = new GetSectionsOnlineRequest(requestDocument, null, null, null, null);
        SectionLinkCollectionResponse result = TestInitializer.wordsApi.getSectionsOnline(request);
        TestSection.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteSection() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteSection.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteSectionRequest request = new DeleteSectionRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteSection(request);
    }

    @Test
    public void testDeleteSectionOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteSectionOnlineRequest request = new DeleteSectionOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteSectionOnline(request);
        TestSection.assertNotNull((Object)result);
    }

    @Test
    public void testMergeWithNext() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestMergeWithNext.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "DocumentElements/Sections/Source.docx"), this.remoteDataFolder + "/" + remoteFileName);
        MergeWithNextRequest request = new MergeWithNextRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.mergeWithNext(request);
    }

    @Test
    public void testMergeWithNextOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, "DocumentElements/Sections/Source.docx").toAbsolutePath());
        MergeWithNextOnlineRequest request = new MergeWithNextOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.mergeWithNextOnline(request);
        TestSection.assertNotNull((Object)result);
    }

    @Test
    public void testInsertSection() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertSection.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        InsertSectionRequest request = new InsertSectionRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.insertSection(request);
    }

    @Test
    public void testInsertSectionOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        InsertSectionOnlineRequest request = new InsertSectionOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.insertSectionOnline(request);
        TestSection.assertNotNull((Object)result);
    }

    @Test
    public void testLinkHeaderFootersToPrevious() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestLinkHeaderFootersToPrevious.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, "DocumentElements/Sections/Source.docx"), this.remoteDataFolder + "/" + remoteFileName);
        LinkHeaderFootersToPreviousRequest request = new LinkHeaderFootersToPreviousRequest(remoteFileName, Integer.valueOf(1), this.remoteDataFolder, null, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.linkHeaderFootersToPrevious(request);
    }
}

