/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.text;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.ReplaceTextParameters;
import com.aspose.words.cloud.model.ReplaceTextResponse;
import com.aspose.words.cloud.model.SearchResponse;
import com.aspose.words.cloud.model.SearchResult;
import com.aspose.words.cloud.model.requests.ReplaceTextOnlineRequest;
import com.aspose.words.cloud.model.requests.ReplaceTextRequest;
import com.aspose.words.cloud.model.requests.SearchOnlineRequest;
import com.aspose.words.cloud.model.requests.SearchRequest;
import com.aspose.words.cloud.model.responses.ReplaceTextOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestText
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Text";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testReplaceText() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestReplaceText.docx";
        String localFile = "Common/test_multi_pages.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, localFile), this.remoteDataFolder + "/" + remoteFileName);
        ReplaceTextParameters requestReplaceText = new ReplaceTextParameters();
        requestReplaceText.setOldValue("Testing");
        requestReplaceText.setNewValue("Aspose testing");
        requestReplaceText.setIsMatchCase(Boolean.valueOf(true));
        requestReplaceText.setIsMatchWholeWord(Boolean.valueOf(false));
        requestReplaceText.setIsOldValueRegex(Boolean.valueOf(false));
        ReplaceTextRequest request = new ReplaceTextRequest(remoteFileName, requestReplaceText, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        ReplaceTextResponse result = TestInitializer.wordsApi.replaceText(request);
        TestText.assertNotNull((Object)result);
        TestText.assertEquals((Object)3, (Object)result.getMatches());
    }

    @Test
    public void testReplaceTextOnline() throws ApiException, MessagingException, IOException {
        String localFile = "Common/test_multi_pages.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, localFile).toAbsolutePath());
        ReplaceTextParameters requestReplaceText = new ReplaceTextParameters();
        requestReplaceText.setOldValue("aspose");
        requestReplaceText.setNewValue("aspose new");
        requestReplaceText.setIsMatchCase(Boolean.valueOf(true));
        requestReplaceText.setIsMatchWholeWord(Boolean.valueOf(false));
        requestReplaceText.setIsOldValueRegex(Boolean.valueOf(false));
        ReplaceTextOnlineRequest request = new ReplaceTextOnlineRequest(requestDocument, requestReplaceText, null, null, null, null, null, null, null);
        ReplaceTextOnlineResponse result = TestInitializer.wordsApi.replaceTextOnline(request);
        TestText.assertNotNull((Object)result);
    }

    @Test
    public void testSearch() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestSearch.docx";
        String localFile = "DocumentElements/Text/SampleWordDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, localFile), this.remoteDataFolder + "/" + remoteFileName);
        SearchRequest request = new SearchRequest(remoteFileName, "aspose", this.remoteDataFolder, null, null, null, null, null);
        SearchResponse result = TestInitializer.wordsApi.search(request);
        TestText.assertNotNull((Object)result);
        TestText.assertNotNull((Object)result.getSearchResults());
        TestText.assertNotNull((Object)result.getSearchResults().getResultsList());
        TestText.assertEquals((int)23, (int)result.getSearchResults().getResultsList().size());
        TestText.assertNotNull((Object)((SearchResult)result.getSearchResults().getResultsList().get(0)).getRangeStart());
        TestText.assertEquals((Object)65, (Object)((SearchResult)result.getSearchResults().getResultsList().get(0)).getRangeStart().getOffset());
    }

    @Test
    public void testSearchOnline() throws ApiException, MessagingException, IOException {
        String localFile = "DocumentElements/Text/SampleWordDocument.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, localFile).toAbsolutePath());
        SearchOnlineRequest request = new SearchOnlineRequest(requestDocument, "aspose", null, null, null, null);
        SearchResponse result = TestInitializer.wordsApi.searchOnline(request);
        TestText.assertNotNull((Object)result);
    }
}

