/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.EncryptorFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class SimpleEncryptorFactory
implements EncryptorFactory {
    private String exponent;
    private String modulus;

    public SimpleEncryptorFactory(String exponent, String modulus) {
        if (exponent == null || exponent.isEmpty()) {
            throw new IllegalArgumentException("Exponent must be non empty base64 encoded string");
        }
        if (modulus == null || modulus.isEmpty()) {
            throw new IllegalArgumentException("Modulus must be non empty base64 encoded string");
        }
        this.exponent = exponent;
        this.modulus = modulus;
    }

    @Override
    public Cipher create() throws ApiException, IOException {
        try {
            byte[] modulusByte = Base64.getDecoder().decode(this.modulus);
            BigInteger modulusInt = new BigInteger(1, modulusByte);
            byte[] exponentByte = Base64.getDecoder().decode(this.exponent);
            BigInteger exponentInt = new BigInteger(1, exponentByte);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulusInt, exponentInt);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey key = factory.generatePublic(spec);
            Cipher encryptor = Cipher.getInstance("RSA");
            encryptor.init(1, key);
            return encryptor;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new ApiException(e);
        }
    }
}

