/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Api error.")
public class ApiError
implements ModelIfc {
    @SerializedName(value="Code")
    protected String code = null;
    @SerializedName(value="DateTime")
    protected OffsetDateTime dateTime = null;
    @SerializedName(value="Description")
    protected String description = null;
    @SerializedName(value="InnerError")
    protected ApiError innerError = null;
    @SerializedName(value="Message")
    protected String message = null;

    @ApiModelProperty(value="Gets or sets the API error code.")
    public String getCode() {
        return this.code;
    }

    public ApiError code(String code) {
        this.code = code;
        return this;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ApiModelProperty(value="Gets or sets the server DateTime.")
    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public ApiError dateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @ApiModelProperty(value="Gets or sets the error description.")
    public String getDescription() {
        return this.description;
    }

    public ApiError description(String description) {
        this.description = description;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="Gets or sets the inner error.")
    public ApiError getInnerError() {
        return this.innerError;
    }

    public ApiError innerError(ApiError innerError) {
        this.innerError = innerError;
        return this;
    }

    public void setInnerError(ApiError innerError) {
        this.innerError = innerError;
    }

    @ApiModelProperty(value="Gets or sets the error message.")
    public String getMessage() {
        return this.message;
    }

    public ApiError message(String message) {
        this.message = message;
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.innerError != null) {
            this.innerError.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.code, apiError.code) && Objects.equals(this.dateTime, apiError.dateTime) && Objects.equals(this.description, apiError.description) && Objects.equals(this.innerError, apiError.innerError) && Objects.equals(this.message, apiError.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.dateTime, this.description, this.innerError, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.getCode())).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.getDateTime())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.getDescription())).append("\n");
        sb.append("    innerError: ").append(this.toIndentedString(this.getInnerError())).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.getMessage())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

