/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a bookmark to insert.")
public class BookmarkInsert
implements ModelIfc {
    @SerializedName(value="Name")
    protected String name = null;
    @SerializedName(value="Text")
    protected String text = null;
    @SerializedName(value="StartRange")
    protected Position startRange = null;
    @SerializedName(value="EndRange")
    protected Position endRange = null;

    @ApiModelProperty(value="Gets or sets the name of the bookmark.")
    public String getName() {
        return this.name;
    }

    public BookmarkInsert name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Gets or sets text, enclosed in the bookmark.")
    public String getText() {
        return this.text;
    }

    public BookmarkInsert text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Gets or sets the link to start bookmark node.")
    public Position getStartRange() {
        return this.startRange;
    }

    public BookmarkInsert startRange(Position startRange) {
        this.startRange = startRange;
        return this;
    }

    public void setStartRange(Position startRange) {
        this.startRange = startRange;
    }

    @ApiModelProperty(value="Gets or sets the link to end bookmark node.")
    public Position getEndRange() {
        return this.endRange;
    }

    public BookmarkInsert endRange(Position endRange) {
        this.endRange = endRange;
        return this;
    }

    public void setEndRange(Position endRange) {
        this.endRange = endRange;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.name == null) {
            throw new ApiException(400, "Property Name in BookmarkInsert is required.");
        }
        if (this.text == null) {
            throw new ApiException(400, "Property Text in BookmarkInsert is required.");
        }
        if (this.startRange == null) {
            throw new ApiException(400, "Property StartRange in BookmarkInsert is required.");
        }
        if (this.endRange == null) {
            throw new ApiException(400, "Property EndRange in BookmarkInsert is required.");
        }
        if (this.startRange != null) {
            this.startRange.validate();
        }
        if (this.endRange != null) {
            this.endRange.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkInsert bookmarkInsert = (BookmarkInsert)o;
        return Objects.equals(this.name, bookmarkInsert.name) && Objects.equals(this.text, bookmarkInsert.text) && Objects.equals(this.startRange, bookmarkInsert.startRange) && Objects.equals(this.endRange, bookmarkInsert.endRange);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.text, this.startRange, this.endRange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookmarkInsert {\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("    startRange: ").append(this.toIndentedString(this.getStartRange())).append("\n");
        sb.append("    endRange: ").append(this.toIndentedString(this.getEndRange())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

