/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.CommentLink;
import com.aspose.words.cloud.model.DocumentPosition;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.StoryChildNodes;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="DTO container with a comment.")
public class Comment
extends CommentLink {
    @SerializedName(value="RangeStart")
    protected DocumentPosition rangeStart = null;
    @SerializedName(value="RangeEnd")
    protected DocumentPosition rangeEnd = null;
    @SerializedName(value="Author")
    protected String author = null;
    @SerializedName(value="Initial")
    protected String initial = null;
    @SerializedName(value="DateTime")
    protected OffsetDateTime dateTime = null;
    @SerializedName(value="Text")
    protected String text = null;
    @SerializedName(value="Content")
    protected StoryChildNodes content = null;

    @ApiModelProperty(value="Gets or sets the link to comment range start node.")
    public DocumentPosition getRangeStart() {
        return this.rangeStart;
    }

    public Comment rangeStart(DocumentPosition rangeStart) {
        this.rangeStart = rangeStart;
        return this;
    }

    public void setRangeStart(DocumentPosition rangeStart) {
        this.rangeStart = rangeStart;
    }

    @ApiModelProperty(value="Gets or sets the link to comment range end node.")
    public DocumentPosition getRangeEnd() {
        return this.rangeEnd;
    }

    public Comment rangeEnd(DocumentPosition rangeEnd) {
        this.rangeEnd = rangeEnd;
        return this;
    }

    public void setRangeEnd(DocumentPosition rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @ApiModelProperty(value="Gets or sets the author name for a comment. Cannot be null.Default is an empty string.")
    public String getAuthor() {
        return this.author;
    }

    public Comment author(String author) {
        this.author = author;
        return this;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="Gets or sets the initials of the user associated with a specific comment. Cannot be null.Default is an empty string.")
    public String getInitial() {
        return this.initial;
    }

    public Comment initial(String initial) {
        this.initial = initial;
        return this;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    @ApiModelProperty(value="Gets or sets the date and time that the comment was made.")
    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public Comment dateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @ApiModelProperty(value="Gets or sets text of the comment. This method allows to quickly set text of a comment from a string. The string can contain paragraph breaks, this will create paragraphs of text in the comment accordingly.")
    public String getText() {
        return this.text;
    }

    public Comment text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Gets or sets the content of the comment.")
    public StoryChildNodes getContent() {
        return this.content;
    }

    public Comment content(StoryChildNodes content) {
        this.content = content;
        return this;
    }

    public void setContent(StoryChildNodes content) {
        this.content = content;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.rangeStart != null) {
            this.rangeStart.validate();
        }
        if (this.rangeEnd != null) {
            this.rangeEnd.validate();
        }
        if (this.content != null) {
            this.content.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment comment = (Comment)o;
        return Objects.equals(this.rangeStart, comment.rangeStart) && Objects.equals(this.rangeEnd, comment.rangeEnd) && Objects.equals(this.author, comment.author) && Objects.equals(this.initial, comment.initial) && Objects.equals(this.dateTime, comment.dateTime) && Objects.equals(this.text, comment.text) && Objects.equals(this.content, comment.content) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rangeStart, this.rangeEnd, this.author, this.initial, this.dateTime, this.text, this.content, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Comment {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    rangeStart: ").append(this.toIndentedString(this.getRangeStart())).append("\n");
        sb.append("    rangeEnd: ").append(this.toIndentedString(this.getRangeEnd())).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.getAuthor())).append("\n");
        sb.append("    initial: ").append(this.toIndentedString(this.getInitial())).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.getDateTime())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.getContent())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

