/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with compare documents options.")
public class CompareOptions
implements ModelIfc {
    @SerializedName(value="AcceptAllRevisionsBeforeComparison")
    protected Boolean acceptAllRevisionsBeforeComparison = null;
    @SerializedName(value="Granularity")
    protected GranularityEnum granularity = null;
    @SerializedName(value="IgnoreCaseChanges")
    protected Boolean ignoreCaseChanges = null;
    @SerializedName(value="IgnoreComments")
    protected Boolean ignoreComments = null;
    @SerializedName(value="IgnoreFields")
    protected Boolean ignoreFields = null;
    @SerializedName(value="IgnoreFootnotes")
    protected Boolean ignoreFootnotes = null;
    @SerializedName(value="IgnoreFormatting")
    protected Boolean ignoreFormatting = null;
    @SerializedName(value="IgnoreHeadersAndFooters")
    protected Boolean ignoreHeadersAndFooters = null;
    @SerializedName(value="IgnoreTables")
    protected Boolean ignoreTables = null;
    @SerializedName(value="IgnoreTextboxes")
    protected Boolean ignoreTextboxes = null;
    @SerializedName(value="Target")
    protected TargetEnum target = null;

    @ApiModelProperty(value="Gets or sets whether accept revisions before comparison or not.")
    public Boolean getAcceptAllRevisionsBeforeComparison() {
        return this.acceptAllRevisionsBeforeComparison;
    }

    public CompareOptions acceptAllRevisionsBeforeComparison(Boolean acceptAllRevisionsBeforeComparison) {
        this.acceptAllRevisionsBeforeComparison = acceptAllRevisionsBeforeComparison;
        return this;
    }

    public void setAcceptAllRevisionsBeforeComparison(Boolean acceptAllRevisionsBeforeComparison) {
        this.acceptAllRevisionsBeforeComparison = acceptAllRevisionsBeforeComparison;
    }

    @ApiModelProperty(value="Gets or sets the option indicating whether changes are tracked by character or by word.")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public CompareOptions granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether documents comparison is case insensitive. By default comparison is case sensitive.")
    public Boolean getIgnoreCaseChanges() {
        return this.ignoreCaseChanges;
    }

    public CompareOptions ignoreCaseChanges(Boolean ignoreCaseChanges) {
        this.ignoreCaseChanges = ignoreCaseChanges;
        return this;
    }

    public void setIgnoreCaseChanges(Boolean ignoreCaseChanges) {
        this.ignoreCaseChanges = ignoreCaseChanges;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether comments content is ignored. By default comments are not ignored.")
    public Boolean getIgnoreComments() {
        return this.ignoreComments;
    }

    public CompareOptions ignoreComments(Boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        return this;
    }

    public void setIgnoreComments(Boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fields content is ignored. By default fields are not ignored.")
    public Boolean getIgnoreFields() {
        return this.ignoreFields;
    }

    public CompareOptions ignoreFields(Boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
        return this;
    }

    public void setIgnoreFields(Boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether footnotes/endnotes content is ignored. By default footnotes/endnotes are not ignored.")
    public Boolean getIgnoreFootnotes() {
        return this.ignoreFootnotes;
    }

    public CompareOptions ignoreFootnotes(Boolean ignoreFootnotes) {
        this.ignoreFootnotes = ignoreFootnotes;
        return this;
    }

    public void setIgnoreFootnotes(Boolean ignoreFootnotes) {
        this.ignoreFootnotes = ignoreFootnotes;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether formatting is ignored. By default document formatting is not ignored.")
    public Boolean getIgnoreFormatting() {
        return this.ignoreFormatting;
    }

    public CompareOptions ignoreFormatting(Boolean ignoreFormatting) {
        this.ignoreFormatting = ignoreFormatting;
        return this;
    }

    public void setIgnoreFormatting(Boolean ignoreFormatting) {
        this.ignoreFormatting = ignoreFormatting;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether headers and footers content is ignored. By default headers and footers are not ignored.")
    public Boolean getIgnoreHeadersAndFooters() {
        return this.ignoreHeadersAndFooters;
    }

    public CompareOptions ignoreHeadersAndFooters(Boolean ignoreHeadersAndFooters) {
        this.ignoreHeadersAndFooters = ignoreHeadersAndFooters;
        return this;
    }

    public void setIgnoreHeadersAndFooters(Boolean ignoreHeadersAndFooters) {
        this.ignoreHeadersAndFooters = ignoreHeadersAndFooters;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether tables content is ignored. By default tables are not ignored.")
    public Boolean getIgnoreTables() {
        return this.ignoreTables;
    }

    public CompareOptions ignoreTables(Boolean ignoreTables) {
        this.ignoreTables = ignoreTables;
        return this;
    }

    public void setIgnoreTables(Boolean ignoreTables) {
        this.ignoreTables = ignoreTables;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether textboxes content is ignored. By default textboxes are not ignored.")
    public Boolean getIgnoreTextboxes() {
        return this.ignoreTextboxes;
    }

    public CompareOptions ignoreTextboxes(Boolean ignoreTextboxes) {
        this.ignoreTextboxes = ignoreTextboxes;
        return this;
    }

    public void setIgnoreTextboxes(Boolean ignoreTextboxes) {
        this.ignoreTextboxes = ignoreTextboxes;
    }

    @ApiModelProperty(value="Gets or sets the option that controls which document shall be used as a target during comparison.")
    public TargetEnum getTarget() {
        return this.target;
    }

    public CompareOptions target(TargetEnum target) {
        this.target = target;
        return this;
    }

    public void setTarget(TargetEnum target) {
        this.target = target;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareOptions compareOptions = (CompareOptions)o;
        return Objects.equals(this.acceptAllRevisionsBeforeComparison, compareOptions.acceptAllRevisionsBeforeComparison) && Objects.equals((Object)this.granularity, (Object)compareOptions.granularity) && Objects.equals(this.ignoreCaseChanges, compareOptions.ignoreCaseChanges) && Objects.equals(this.ignoreComments, compareOptions.ignoreComments) && Objects.equals(this.ignoreFields, compareOptions.ignoreFields) && Objects.equals(this.ignoreFootnotes, compareOptions.ignoreFootnotes) && Objects.equals(this.ignoreFormatting, compareOptions.ignoreFormatting) && Objects.equals(this.ignoreHeadersAndFooters, compareOptions.ignoreHeadersAndFooters) && Objects.equals(this.ignoreTables, compareOptions.ignoreTables) && Objects.equals(this.ignoreTextboxes, compareOptions.ignoreTextboxes) && Objects.equals((Object)this.target, (Object)compareOptions.target);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptAllRevisionsBeforeComparison, this.granularity, this.ignoreCaseChanges, this.ignoreComments, this.ignoreFields, this.ignoreFootnotes, this.ignoreFormatting, this.ignoreHeadersAndFooters, this.ignoreTables, this.ignoreTextboxes, this.target});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompareOptions {\n");
        sb.append("    acceptAllRevisionsBeforeComparison: ").append(this.toIndentedString(this.getAcceptAllRevisionsBeforeComparison())).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.getGranularity())).append("\n");
        sb.append("    ignoreCaseChanges: ").append(this.toIndentedString(this.getIgnoreCaseChanges())).append("\n");
        sb.append("    ignoreComments: ").append(this.toIndentedString(this.getIgnoreComments())).append("\n");
        sb.append("    ignoreFields: ").append(this.toIndentedString(this.getIgnoreFields())).append("\n");
        sb.append("    ignoreFootnotes: ").append(this.toIndentedString(this.getIgnoreFootnotes())).append("\n");
        sb.append("    ignoreFormatting: ").append(this.toIndentedString(this.getIgnoreFormatting())).append("\n");
        sb.append("    ignoreHeadersAndFooters: ").append(this.toIndentedString(this.getIgnoreHeadersAndFooters())).append("\n");
        sb.append("    ignoreTables: ").append(this.toIndentedString(this.getIgnoreTables())).append("\n");
        sb.append("    ignoreTextboxes: ").append(this.toIndentedString(this.getIgnoreTextboxes())).append("\n");
        sb.append("    target: ").append(this.toIndentedString((Object)this.getTarget())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GranularityEnum {
        CHARLEVEL("CharLevel"),
        WORDLEVEL("WordLevel");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GranularityEnum fromValue(String text) {
            for (GranularityEnum b : GranularityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<GranularityEnum> {
            public void write(JsonWriter jsonWriter, GranularityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GranularityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GranularityEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TargetEnum {
        CURRENT("Current"),
        NEW("New");

        private String value;

        private TargetEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TargetEnum fromValue(String text) {
            for (TargetEnum b : TargetEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TargetEnum> {
            public void write(JsonWriter jsonWriter, TargetEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TargetEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TargetEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

