/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for docling json save options.")
public class DoclingSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="RenderNonImageShapes")
    protected Boolean renderNonImageShapes = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether non-image shapes should be rendered and written to the output Docling JSON document. If the property is false, non-image shapes are not exported to the output document. The default value is false.")
    public Boolean getRenderNonImageShapes() {
        return this.renderNonImageShapes;
    }

    public DoclingSaveOptionsData renderNonImageShapes(Boolean renderNonImageShapes) {
        this.renderNonImageShapes = renderNonImageShapes;
        return this;
    }

    public void setRenderNonImageShapes(Boolean renderNonImageShapes) {
        this.renderNonImageShapes = renderNonImageShapes;
    }

    public DoclingSaveOptionsData() {
        this.saveFormat = "docling";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoclingSaveOptionsData doclingSaveOptionsData = (DoclingSaveOptionsData)o;
        return Objects.equals(this.renderNonImageShapes, doclingSaveOptionsData.renderNonImageShapes) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.renderNonImageShapes, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DoclingSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    renderNonImageShapes: ").append(this.toIndentedString(this.getRenderNonImageShapes())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

