/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.BaseEntry;
import com.aspose.words.cloud.model.FileReference;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a document which will be appended to the original resource document.")
public class DocumentEntry
extends BaseEntry {
    @SerializedName(value="EncryptedPassword")
    protected String encryptedPassword = null;
    @SerializedName(value="ImportFormatMode")
    protected ImportFormatModeEnum importFormatMode = null;

    @ApiModelProperty(value="Gets or sets document password encrypted on API public key. The default value is null (the document has no password).")
    @Deprecated
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Deprecated
    public DocumentEntry encryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
        return this;
    }

    @Deprecated
    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @ApiModelProperty(value="Gets or sets the option that controls formatting will be used: appended or destination document. Can be KeepSourceFormatting or UseDestinationStyles.")
    public ImportFormatModeEnum getImportFormatMode() {
        return this.importFormatMode;
    }

    public DocumentEntry importFormatMode(ImportFormatModeEnum importFormatMode) {
        this.importFormatMode = importFormatMode;
        return this;
    }

    public void setImportFormatMode(ImportFormatModeEnum importFormatMode) {
        this.importFormatMode = importFormatMode;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        super.getFilesContent(resultFilesContent);
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.importFormatMode == null) {
            throw new ApiException(400, "Property ImportFormatMode in DocumentEntry is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentEntry documentEntry = (DocumentEntry)o;
        return Objects.equals(this.encryptedPassword, documentEntry.encryptedPassword) && Objects.equals((Object)this.importFormatMode, (Object)documentEntry.importFormatMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.encryptedPassword, this.importFormatMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentEntry {\n");
        sb.append("    fileReference: ").append(this.toIndentedString(this.getFileReference())).append("\n");
        sb.append("    encryptedPassword: ").append(this.toIndentedString(this.getEncryptedPassword())).append("\n");
        sb.append("    importFormatMode: ").append(this.toIndentedString((Object)this.getImportFormatMode())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImportFormatModeEnum {
        USEDESTINATIONSTYLES("UseDestinationStyles"),
        KEEPSOURCEFORMATTING("KeepSourceFormatting"),
        KEEPDIFFERENTSTYLES("KeepDifferentStyles");

        private String value;

        private ImportFormatModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImportFormatModeEnum fromValue(String text) {
            for (ImportFormatModeEnum b : ImportFormatModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImportFormatModeEnum> {
            public void write(JsonWriter jsonWriter, ImportFormatModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImportFormatModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImportFormatModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

