/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.BaseEntryList;
import com.aspose.words.cloud.model.DocumentEntry;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a list of documents which will be appended to the original resource document.")
public class DocumentEntryList
extends BaseEntryList {
    @SerializedName(value="AppendAllEntriesToOneSection")
    protected Boolean appendAllEntriesToOneSection = null;
    @SerializedName(value="ApplyBaseDocumentHeadersAndFootersToAppendingDocuments")
    protected Boolean applyBaseDocumentHeadersAndFootersToAppendingDocuments = null;
    @SerializedName(value="DocumentEntries")
    protected List<DocumentEntry> documentEntries = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether to append all documents to the same section.")
    public Boolean getAppendAllEntriesToOneSection() {
        return this.appendAllEntriesToOneSection;
    }

    public DocumentEntryList appendAllEntriesToOneSection(Boolean appendAllEntriesToOneSection) {
        this.appendAllEntriesToOneSection = appendAllEntriesToOneSection;
        return this;
    }

    public void setAppendAllEntriesToOneSection(Boolean appendAllEntriesToOneSection) {
        this.appendAllEntriesToOneSection = appendAllEntriesToOneSection;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to apply headers and footers from base document to appending documents. The default value is true.")
    public Boolean getApplyBaseDocumentHeadersAndFootersToAppendingDocuments() {
        return this.applyBaseDocumentHeadersAndFootersToAppendingDocuments;
    }

    public DocumentEntryList applyBaseDocumentHeadersAndFootersToAppendingDocuments(Boolean applyBaseDocumentHeadersAndFootersToAppendingDocuments) {
        this.applyBaseDocumentHeadersAndFootersToAppendingDocuments = applyBaseDocumentHeadersAndFootersToAppendingDocuments;
        return this;
    }

    public void setApplyBaseDocumentHeadersAndFootersToAppendingDocuments(Boolean applyBaseDocumentHeadersAndFootersToAppendingDocuments) {
        this.applyBaseDocumentHeadersAndFootersToAppendingDocuments = applyBaseDocumentHeadersAndFootersToAppendingDocuments;
    }

    @ApiModelProperty(value="Gets or sets the list of documents.")
    public List<DocumentEntry> getDocumentEntries() {
        return this.documentEntries;
    }

    public DocumentEntryList documentEntries(List<DocumentEntry> documentEntries) {
        this.documentEntries = documentEntries;
        return this;
    }

    public DocumentEntryList addDocumentEntriesItem(DocumentEntry documentEntriesItem) {
        if (this.documentEntries == null) {
            this.documentEntries = new ArrayList<DocumentEntry>();
        }
        this.documentEntries.add(documentEntriesItem);
        return this;
    }

    public void setDocumentEntries(List<DocumentEntry> documentEntries) {
        this.documentEntries = documentEntries;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        super.getFilesContent(resultFilesContent);
        if (this.documentEntries != null) {
            for (ModelIfc modelIfc : this.documentEntries) {
                modelIfc.getFilesContent(resultFilesContent);
            }
        }
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.documentEntries == null) {
            throw new ApiException(400, "Property DocumentEntries in DocumentEntryList is required.");
        }
        if (this.documentEntries != null) {
            for (ModelIfc modelIfc : this.documentEntries) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentEntryList documentEntryList = (DocumentEntryList)o;
        return Objects.equals(this.appendAllEntriesToOneSection, documentEntryList.appendAllEntriesToOneSection) && Objects.equals(this.applyBaseDocumentHeadersAndFootersToAppendingDocuments, documentEntryList.applyBaseDocumentHeadersAndFootersToAppendingDocuments) && Objects.equals(this.documentEntries, documentEntryList.documentEntries) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appendAllEntriesToOneSection, this.applyBaseDocumentHeadersAndFootersToAppendingDocuments, this.documentEntries, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentEntryList {\n");
        sb.append("    appendAllEntriesToOneSection: ").append(this.toIndentedString(this.getAppendAllEntriesToOneSection())).append("\n");
        sb.append("    applyBaseDocumentHeadersAndFootersToAppendingDocuments: ").append(this.toIndentedString(this.getApplyBaseDocumentHeadersAndFootersToAppendingDocuments())).append("\n");
        sb.append("    documentEntries: ").append(this.toIndentedString(this.getDocumentEntries())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

