/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Words document property DTO.")
public class DocumentProperty
extends LinkElement {
    @SerializedName(value="Name")
    protected String name = null;
    @SerializedName(value="Value")
    protected String value = null;
    @SerializedName(value="BuiltIn")
    protected Boolean builtIn = null;

    @ApiModelProperty(value="Gets or sets the name of the document property.")
    public String getName() {
        return this.name;
    }

    public DocumentProperty name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Gets or sets the value of the document property.")
    public String getValue() {
        return this.value;
    }

    public DocumentProperty value(String value) {
        this.value = value;
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the property is built-in or not. If true the property is built-in, if false the property is custom.")
    public Boolean getBuiltIn() {
        return this.builtIn;
    }

    public DocumentProperty builtIn(Boolean builtIn) {
        this.builtIn = builtIn;
        return this;
    }

    public void setBuiltIn(Boolean builtIn) {
        this.builtIn = builtIn;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.builtIn == null) {
            throw new ApiException(400, "Property BuiltIn in DocumentProperty is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentProperty documentProperty = (DocumentProperty)o;
        return Objects.equals(this.name, documentProperty.name) && Objects.equals(this.value, documentProperty.value) && Objects.equals(this.builtIn, documentProperty.builtIn) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.builtIn, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentProperty {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.getValue())).append("\n");
        sb.append("    builtIn: ").append(this.toIndentedString(this.getBuiltIn())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

