/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FootnotesStatData;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.PageStatData;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for the document's statistical data.")
public class DocumentStatData
implements ModelIfc {
    @SerializedName(value="FootnotesStatData")
    protected FootnotesStatData footnotesStatData = null;
    @SerializedName(value="PageCount")
    protected Integer pageCount = null;
    @SerializedName(value="ParagraphCount")
    protected Integer paragraphCount = null;
    @SerializedName(value="WordCount")
    protected Integer wordCount = null;
    @SerializedName(value="PageStatData")
    protected List<PageStatData> pageStatData = null;

    @ApiModelProperty(value="Gets or sets the detailed statistics on footnotes.")
    public FootnotesStatData getFootnotesStatData() {
        return this.footnotesStatData;
    }

    public DocumentStatData footnotesStatData(FootnotesStatData footnotesStatData) {
        this.footnotesStatData = footnotesStatData;
        return this;
    }

    public void setFootnotesStatData(FootnotesStatData footnotesStatData) {
        this.footnotesStatData = footnotesStatData;
    }

    @ApiModelProperty(value="Gets or sets the total count of pages in the document.")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public DocumentStatData pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    @ApiModelProperty(value="Gets or sets the total count of paragraphs in the document.")
    public Integer getParagraphCount() {
        return this.paragraphCount;
    }

    public DocumentStatData paragraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
        return this;
    }

    public void setParagraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
    }

    @ApiModelProperty(value="Gets or sets the total count of words in the document.")
    public Integer getWordCount() {
        return this.wordCount;
    }

    public DocumentStatData wordCount(Integer wordCount) {
        this.wordCount = wordCount;
        return this;
    }

    public void setWordCount(Integer wordCount) {
        this.wordCount = wordCount;
    }

    @ApiModelProperty(value="Gets or sets the detailed statistics on all pages.")
    public List<PageStatData> getPageStatData() {
        return this.pageStatData;
    }

    public DocumentStatData pageStatData(List<PageStatData> pageStatData) {
        this.pageStatData = pageStatData;
        return this;
    }

    public DocumentStatData addPageStatDataItem(PageStatData pageStatDataItem) {
        if (this.pageStatData == null) {
            this.pageStatData = new ArrayList<PageStatData>();
        }
        this.pageStatData.add(pageStatDataItem);
        return this;
    }

    public void setPageStatData(List<PageStatData> pageStatData) {
        this.pageStatData = pageStatData;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.pageCount == null) {
            throw new ApiException(400, "Property PageCount in DocumentStatData is required.");
        }
        if (this.paragraphCount == null) {
            throw new ApiException(400, "Property ParagraphCount in DocumentStatData is required.");
        }
        if (this.wordCount == null) {
            throw new ApiException(400, "Property WordCount in DocumentStatData is required.");
        }
        if (this.footnotesStatData != null) {
            this.footnotesStatData.validate();
        }
        if (this.pageStatData != null) {
            for (ModelIfc modelIfc : this.pageStatData) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentStatData documentStatData = (DocumentStatData)o;
        return Objects.equals(this.footnotesStatData, documentStatData.footnotesStatData) && Objects.equals(this.pageCount, documentStatData.pageCount) && Objects.equals(this.paragraphCount, documentStatData.paragraphCount) && Objects.equals(this.wordCount, documentStatData.wordCount) && Objects.equals(this.pageStatData, documentStatData.pageStatData);
    }

    public int hashCode() {
        return Objects.hash(this.footnotesStatData, this.pageCount, this.paragraphCount, this.wordCount, this.pageStatData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentStatData {\n");
        sb.append("    footnotesStatData: ").append(this.toIndentedString(this.getFootnotesStatData())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    paragraphCount: ").append(this.toIndentedString(this.getParagraphCount())).append("\n");
        sb.append("    wordCount: ").append(this.toIndentedString(this.getWordCount())).append("\n");
        sb.append("    pageStatData: ").append(this.toIndentedString(this.getPageStatData())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

