/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.DrawingObjectLink;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.WordsApiLink;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a DrawingObject.")
public class DrawingObject
extends DrawingObjectLink {
    @SerializedName(value="RenderLinks")
    protected List<WordsApiLink> renderLinks = null;
    @SerializedName(value="Width")
    protected Double width = null;
    @SerializedName(value="Height")
    protected Double height = null;
    @SerializedName(value="OleDataLink")
    protected WordsApiLink oleDataLink = null;
    @SerializedName(value="ImageDataLink")
    protected WordsApiLink imageDataLink = null;
    @SerializedName(value="RelativeHorizontalPosition")
    protected RelativeHorizontalPositionEnum relativeHorizontalPosition = null;
    @SerializedName(value="Left")
    protected Double left = null;
    @SerializedName(value="RelativeVerticalPosition")
    protected RelativeVerticalPositionEnum relativeVerticalPosition = null;
    @SerializedName(value="Top")
    protected Double top = null;
    @SerializedName(value="WrapType")
    protected WrapTypeEnum wrapType = null;

    @ApiModelProperty(value="Gets or sets the list of links that originate from this DrawingObjectDto.")
    public List<WordsApiLink> getRenderLinks() {
        return this.renderLinks;
    }

    public DrawingObject renderLinks(List<WordsApiLink> renderLinks) {
        this.renderLinks = renderLinks;
        return this;
    }

    public DrawingObject addRenderLinksItem(WordsApiLink renderLinksItem) {
        if (this.renderLinks == null) {
            this.renderLinks = new ArrayList<WordsApiLink>();
        }
        this.renderLinks.add(renderLinksItem);
        return this;
    }

    public void setRenderLinks(List<WordsApiLink> renderLinks) {
        this.renderLinks = renderLinks;
    }

    @ApiModelProperty(value="Gets or sets the width of the DrawingObjects in points.")
    public Double getWidth() {
        return this.width;
    }

    public DrawingObject width(Double width) {
        this.width = width;
        return this;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @ApiModelProperty(value="Gets or sets the height of the DrawingObject in points.")
    public Double getHeight() {
        return this.height;
    }

    public DrawingObject height(Double height) {
        this.height = height;
        return this;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    @ApiModelProperty(value="Gets or sets the link to OLE object. Can be null if shape does not have OLE data.")
    public WordsApiLink getOleDataLink() {
        return this.oleDataLink;
    }

    public DrawingObject oleDataLink(WordsApiLink oleDataLink) {
        this.oleDataLink = oleDataLink;
        return this;
    }

    public void setOleDataLink(WordsApiLink oleDataLink) {
        this.oleDataLink = oleDataLink;
    }

    @ApiModelProperty(value="Gets or sets the link to image data. Can be null if shape does not have an image.")
    public WordsApiLink getImageDataLink() {
        return this.imageDataLink;
    }

    public DrawingObject imageDataLink(WordsApiLink imageDataLink) {
        this.imageDataLink = imageDataLink;
        return this;
    }

    public void setImageDataLink(WordsApiLink imageDataLink) {
        this.imageDataLink = imageDataLink;
    }

    @ApiModelProperty(value="Gets or sets the relative horizontal position, from which the distance to the image is measured.")
    public RelativeHorizontalPositionEnum getRelativeHorizontalPosition() {
        return this.relativeHorizontalPosition;
    }

    public DrawingObject relativeHorizontalPosition(RelativeHorizontalPositionEnum relativeHorizontalPosition) {
        this.relativeHorizontalPosition = relativeHorizontalPosition;
        return this;
    }

    public void setRelativeHorizontalPosition(RelativeHorizontalPositionEnum relativeHorizontalPosition) {
        this.relativeHorizontalPosition = relativeHorizontalPosition;
    }

    @ApiModelProperty(value="Gets or sets the distance in points from the origin to the left side of the image.")
    public Double getLeft() {
        return this.left;
    }

    public DrawingObject left(Double left) {
        this.left = left;
        return this;
    }

    public void setLeft(Double left) {
        this.left = left;
    }

    @ApiModelProperty(value="Gets or sets the relative vertical position, from which the distance to the image is measured.")
    public RelativeVerticalPositionEnum getRelativeVerticalPosition() {
        return this.relativeVerticalPosition;
    }

    public DrawingObject relativeVerticalPosition(RelativeVerticalPositionEnum relativeVerticalPosition) {
        this.relativeVerticalPosition = relativeVerticalPosition;
        return this;
    }

    public void setRelativeVerticalPosition(RelativeVerticalPositionEnum relativeVerticalPosition) {
        this.relativeVerticalPosition = relativeVerticalPosition;
    }

    @ApiModelProperty(value="Gets or sets the distance in points from the origin to the top side of the image.")
    public Double getTop() {
        return this.top;
    }

    public DrawingObject top(Double top) {
        this.top = top;
        return this;
    }

    public void setTop(Double top) {
        this.top = top;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how to wrap text around the image.")
    public WrapTypeEnum getWrapType() {
        return this.wrapType;
    }

    public DrawingObject wrapType(WrapTypeEnum wrapType) {
        this.wrapType = wrapType;
        return this;
    }

    public void setWrapType(WrapTypeEnum wrapType) {
        this.wrapType = wrapType;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.renderLinks != null) {
            for (ModelIfc modelIfc : this.renderLinks) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.oleDataLink != null) {
            this.oleDataLink.validate();
        }
        if (this.imageDataLink != null) {
            this.imageDataLink.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawingObject drawingObject = (DrawingObject)o;
        return Objects.equals(this.renderLinks, drawingObject.renderLinks) && Objects.equals(this.width, drawingObject.width) && Objects.equals(this.height, drawingObject.height) && Objects.equals(this.oleDataLink, drawingObject.oleDataLink) && Objects.equals(this.imageDataLink, drawingObject.imageDataLink) && Objects.equals((Object)this.relativeHorizontalPosition, (Object)drawingObject.relativeHorizontalPosition) && Objects.equals(this.left, drawingObject.left) && Objects.equals((Object)this.relativeVerticalPosition, (Object)drawingObject.relativeVerticalPosition) && Objects.equals(this.top, drawingObject.top) && Objects.equals((Object)this.wrapType, (Object)drawingObject.wrapType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.renderLinks, this.width, this.height, this.oleDataLink, this.imageDataLink, this.relativeHorizontalPosition, this.left, this.relativeVerticalPosition, this.top, this.wrapType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawingObject {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    renderLinks: ").append(this.toIndentedString(this.getRenderLinks())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.getWidth())).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.getHeight())).append("\n");
        sb.append("    oleDataLink: ").append(this.toIndentedString(this.getOleDataLink())).append("\n");
        sb.append("    imageDataLink: ").append(this.toIndentedString(this.getImageDataLink())).append("\n");
        sb.append("    relativeHorizontalPosition: ").append(this.toIndentedString((Object)this.getRelativeHorizontalPosition())).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.getLeft())).append("\n");
        sb.append("    relativeVerticalPosition: ").append(this.toIndentedString((Object)this.getRelativeVerticalPosition())).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.getTop())).append("\n");
        sb.append("    wrapType: ").append(this.toIndentedString((Object)this.getWrapType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelativeHorizontalPositionEnum {
        MARGIN("Margin"),
        PAGE("Page"),
        COLUMN("Column"),
        DEFAULT("Default"),
        CHARACTER("Character"),
        LEFTMARGIN("LeftMargin"),
        RIGHTMARGIN("RightMargin"),
        INSIDEMARGIN("InsideMargin"),
        OUTSIDEMARGIN("OutsideMargin");

        private String value;

        private RelativeHorizontalPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelativeHorizontalPositionEnum fromValue(String text) {
            for (RelativeHorizontalPositionEnum b : RelativeHorizontalPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RelativeHorizontalPositionEnum> {
            public void write(JsonWriter jsonWriter, RelativeHorizontalPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RelativeHorizontalPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelativeHorizontalPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelativeVerticalPositionEnum {
        MARGIN("Margin"),
        TABLEDEFAULT("TableDefault"),
        PAGE("Page"),
        PARAGRAPH("Paragraph"),
        TEXTFRAMEDEFAULT("TextFrameDefault"),
        LINE("Line"),
        TOPMARGIN("TopMargin"),
        BOTTOMMARGIN("BottomMargin"),
        INSIDEMARGIN("InsideMargin"),
        OUTSIDEMARGIN("OutsideMargin");

        private String value;

        private RelativeVerticalPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelativeVerticalPositionEnum fromValue(String text) {
            for (RelativeVerticalPositionEnum b : RelativeVerticalPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RelativeVerticalPositionEnum> {
            public void write(JsonWriter jsonWriter, RelativeVerticalPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RelativeVerticalPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelativeVerticalPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WrapTypeEnum {
        INLINE("Inline"),
        TOPBOTTOM("TopBottom"),
        SQUARE("Square"),
        NONE("None"),
        TIGHT("Tight"),
        THROUGH("Through");

        private String value;

        private WrapTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WrapTypeEnum fromValue(String text) {
            for (WrapTypeEnum b : WrapTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WrapTypeEnum> {
            public void write(JsonWriter jsonWriter, WrapTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WrapTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WrapTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

