/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Drawing object element for insert.")
public class DrawingObjectInsert
implements ModelIfc {
    @SerializedName(value="Position")
    protected Position position = null;
    @SerializedName(value="RelativeHorizontalPosition")
    protected RelativeHorizontalPositionEnum relativeHorizontalPosition = null;
    @SerializedName(value="Left")
    protected Double left = null;
    @SerializedName(value="RelativeVerticalPosition")
    protected RelativeVerticalPositionEnum relativeVerticalPosition = null;
    @SerializedName(value="Top")
    protected Double top = null;
    @SerializedName(value="Width")
    protected Double width = null;
    @SerializedName(value="Height")
    protected Double height = null;
    @SerializedName(value="WrapType")
    protected WrapTypeEnum wrapType = null;
    @SerializedName(value="AspectRatioLocked")
    protected Boolean aspectRatioLocked = null;

    @ApiModelProperty(value="Gets or sets the position, where the DrawingObject will be inserted.")
    public Position getPosition() {
        return this.position;
    }

    public DrawingObjectInsert position(Position position) {
        this.position = position;
        return this;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @ApiModelProperty(value="Gets or sets the relative horizontal position, from which the distance to the image is measured.")
    public RelativeHorizontalPositionEnum getRelativeHorizontalPosition() {
        return this.relativeHorizontalPosition;
    }

    public DrawingObjectInsert relativeHorizontalPosition(RelativeHorizontalPositionEnum relativeHorizontalPosition) {
        this.relativeHorizontalPosition = relativeHorizontalPosition;
        return this;
    }

    public void setRelativeHorizontalPosition(RelativeHorizontalPositionEnum relativeHorizontalPosition) {
        this.relativeHorizontalPosition = relativeHorizontalPosition;
    }

    @ApiModelProperty(value="Gets or sets the distance in points from the origin to the left side of the image.")
    public Double getLeft() {
        return this.left;
    }

    public DrawingObjectInsert left(Double left) {
        this.left = left;
        return this;
    }

    public void setLeft(Double left) {
        this.left = left;
    }

    @ApiModelProperty(value="Gets or sets the relative vertical position, from which the distance to the image is measured.")
    public RelativeVerticalPositionEnum getRelativeVerticalPosition() {
        return this.relativeVerticalPosition;
    }

    public DrawingObjectInsert relativeVerticalPosition(RelativeVerticalPositionEnum relativeVerticalPosition) {
        this.relativeVerticalPosition = relativeVerticalPosition;
        return this;
    }

    public void setRelativeVerticalPosition(RelativeVerticalPositionEnum relativeVerticalPosition) {
        this.relativeVerticalPosition = relativeVerticalPosition;
    }

    @ApiModelProperty(value="Gets or sets the distance in points from the origin to the top side of the image.")
    public Double getTop() {
        return this.top;
    }

    public DrawingObjectInsert top(Double top) {
        this.top = top;
        return this;
    }

    public void setTop(Double top) {
        this.top = top;
    }

    @ApiModelProperty(value="Gets or sets the width of the DrawingObjects in points.")
    public Double getWidth() {
        return this.width;
    }

    public DrawingObjectInsert width(Double width) {
        this.width = width;
        return this;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @ApiModelProperty(value="Gets or sets the height of the DrawingObject in points.")
    public Double getHeight() {
        return this.height;
    }

    public DrawingObjectInsert height(Double height) {
        this.height = height;
        return this;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    @ApiModelProperty(value="Gets or sets the option indicating how to wrap text around the image.")
    public WrapTypeEnum getWrapType() {
        return this.wrapType;
    }

    public DrawingObjectInsert wrapType(WrapTypeEnum wrapType) {
        this.wrapType = wrapType;
        return this;
    }

    public void setWrapType(WrapTypeEnum wrapType) {
        this.wrapType = wrapType;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether AspectRatioLocked option on or off.")
    public Boolean getAspectRatioLocked() {
        return this.aspectRatioLocked;
    }

    public DrawingObjectInsert aspectRatioLocked(Boolean aspectRatioLocked) {
        this.aspectRatioLocked = aspectRatioLocked;
        return this;
    }

    public void setAspectRatioLocked(Boolean aspectRatioLocked) {
        this.aspectRatioLocked = aspectRatioLocked;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.relativeHorizontalPosition == null) {
            throw new ApiException(400, "Property RelativeHorizontalPosition in DrawingObjectInsert is required.");
        }
        if (this.left == null) {
            throw new ApiException(400, "Property Left in DrawingObjectInsert is required.");
        }
        if (this.relativeVerticalPosition == null) {
            throw new ApiException(400, "Property RelativeVerticalPosition in DrawingObjectInsert is required.");
        }
        if (this.top == null) {
            throw new ApiException(400, "Property Top in DrawingObjectInsert is required.");
        }
        if (this.width == null) {
            throw new ApiException(400, "Property Width in DrawingObjectInsert is required.");
        }
        if (this.height == null) {
            throw new ApiException(400, "Property Height in DrawingObjectInsert is required.");
        }
        if (this.wrapType == null) {
            throw new ApiException(400, "Property WrapType in DrawingObjectInsert is required.");
        }
        if (this.position != null) {
            this.position.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawingObjectInsert drawingObjectInsert = (DrawingObjectInsert)o;
        return Objects.equals(this.position, drawingObjectInsert.position) && Objects.equals((Object)this.relativeHorizontalPosition, (Object)drawingObjectInsert.relativeHorizontalPosition) && Objects.equals(this.left, drawingObjectInsert.left) && Objects.equals((Object)this.relativeVerticalPosition, (Object)drawingObjectInsert.relativeVerticalPosition) && Objects.equals(this.top, drawingObjectInsert.top) && Objects.equals(this.width, drawingObjectInsert.width) && Objects.equals(this.height, drawingObjectInsert.height) && Objects.equals((Object)this.wrapType, (Object)drawingObjectInsert.wrapType) && Objects.equals(this.aspectRatioLocked, drawingObjectInsert.aspectRatioLocked);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.relativeHorizontalPosition, this.left, this.relativeVerticalPosition, this.top, this.width, this.height, this.wrapType, this.aspectRatioLocked});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DrawingObjectInsert {\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("    relativeHorizontalPosition: ").append(this.toIndentedString((Object)this.getRelativeHorizontalPosition())).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.getLeft())).append("\n");
        sb.append("    relativeVerticalPosition: ").append(this.toIndentedString((Object)this.getRelativeVerticalPosition())).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.getTop())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.getWidth())).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.getHeight())).append("\n");
        sb.append("    wrapType: ").append(this.toIndentedString((Object)this.getWrapType())).append("\n");
        sb.append("    aspectRatioLocked: ").append(this.toIndentedString(this.getAspectRatioLocked())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelativeHorizontalPositionEnum {
        MARGIN("Margin"),
        PAGE("Page"),
        COLUMN("Column"),
        DEFAULT("Default"),
        CHARACTER("Character"),
        LEFTMARGIN("LeftMargin"),
        RIGHTMARGIN("RightMargin"),
        INSIDEMARGIN("InsideMargin"),
        OUTSIDEMARGIN("OutsideMargin");

        private String value;

        private RelativeHorizontalPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelativeHorizontalPositionEnum fromValue(String text) {
            for (RelativeHorizontalPositionEnum b : RelativeHorizontalPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RelativeHorizontalPositionEnum> {
            public void write(JsonWriter jsonWriter, RelativeHorizontalPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RelativeHorizontalPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelativeHorizontalPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelativeVerticalPositionEnum {
        MARGIN("Margin"),
        TABLEDEFAULT("TableDefault"),
        PAGE("Page"),
        PARAGRAPH("Paragraph"),
        TEXTFRAMEDEFAULT("TextFrameDefault"),
        LINE("Line"),
        TOPMARGIN("TopMargin"),
        BOTTOMMARGIN("BottomMargin"),
        INSIDEMARGIN("InsideMargin"),
        OUTSIDEMARGIN("OutsideMargin");

        private String value;

        private RelativeVerticalPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelativeVerticalPositionEnum fromValue(String text) {
            for (RelativeVerticalPositionEnum b : RelativeVerticalPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RelativeVerticalPositionEnum> {
            public void write(JsonWriter jsonWriter, RelativeVerticalPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RelativeVerticalPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelativeVerticalPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WrapTypeEnum {
        INLINE("Inline"),
        TOPBOTTOM("TopBottom"),
        SQUARE("Square"),
        NONE("None"),
        TIGHT("Tight"),
        THROUGH("Through");

        private String value;

        private WrapTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WrapTypeEnum fromValue(String text) {
            for (WrapTypeEnum b : WrapTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WrapTypeEnum> {
            public void write(JsonWriter jsonWriter, WrapTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WrapTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WrapTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

