/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.UserInformation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO for field options.")
public class FieldOptions
implements ModelIfc {
    @SerializedName(value="CurrentUser")
    protected UserInformation currentUser = null;
    @SerializedName(value="CustomTocStyleSeparator")
    protected String customTocStyleSeparator = null;
    @SerializedName(value="DefaultDocumentAuthor")
    protected String defaultDocumentAuthor = null;
    @SerializedName(value="FieldIndexFormat")
    protected FieldIndexFormatEnum fieldIndexFormat = null;
    @SerializedName(value="FieldUpdateCultureName")
    protected String fieldUpdateCultureName = null;
    @SerializedName(value="FieldUpdateCultureSource")
    protected FieldUpdateCultureSourceEnum fieldUpdateCultureSource = null;
    @SerializedName(value="FileName")
    protected String fileName = null;
    @SerializedName(value="IsBidiTextSupportedOnUpdate")
    protected Boolean isBidiTextSupportedOnUpdate = null;
    @SerializedName(value="LegacyNumberFormat")
    protected Boolean legacyNumberFormat = null;
    @SerializedName(value="PreProcessCultureName")
    protected String preProcessCultureName = null;
    @SerializedName(value="TemplateName")
    protected String templateName = null;
    @SerializedName(value="UseInvariantCultureNumberFormat")
    protected Boolean useInvariantCultureNumberFormat = null;
    @SerializedName(value="BuiltInTemplatesPaths")
    protected List<String> builtInTemplatesPaths = null;

    @ApiModelProperty(value="Gets or sets Current User.")
    public UserInformation getCurrentUser() {
        return this.currentUser;
    }

    public FieldOptions currentUser(UserInformation currentUser) {
        this.currentUser = currentUser;
        return this;
    }

    public void setCurrentUser(UserInformation currentUser) {
        this.currentUser = currentUser;
    }

    @ApiModelProperty(value="Gets or sets Custom Toc Style Separator.")
    public String getCustomTocStyleSeparator() {
        return this.customTocStyleSeparator;
    }

    public FieldOptions customTocStyleSeparator(String customTocStyleSeparator) {
        this.customTocStyleSeparator = customTocStyleSeparator;
        return this;
    }

    public void setCustomTocStyleSeparator(String customTocStyleSeparator) {
        this.customTocStyleSeparator = customTocStyleSeparator;
    }

    @ApiModelProperty(value="Gets or sets Default Document Author.")
    public String getDefaultDocumentAuthor() {
        return this.defaultDocumentAuthor;
    }

    public FieldOptions defaultDocumentAuthor(String defaultDocumentAuthor) {
        this.defaultDocumentAuthor = defaultDocumentAuthor;
        return this;
    }

    public void setDefaultDocumentAuthor(String defaultDocumentAuthor) {
        this.defaultDocumentAuthor = defaultDocumentAuthor;
    }

    @ApiModelProperty(value="Gets or sets Field Index Format.")
    public FieldIndexFormatEnum getFieldIndexFormat() {
        return this.fieldIndexFormat;
    }

    public FieldOptions fieldIndexFormat(FieldIndexFormatEnum fieldIndexFormat) {
        this.fieldIndexFormat = fieldIndexFormat;
        return this;
    }

    public void setFieldIndexFormat(FieldIndexFormatEnum fieldIndexFormat) {
        this.fieldIndexFormat = fieldIndexFormat;
    }

    @ApiModelProperty(value="Gets or sets Field Update Culture Name. It is used for all fields if FieldUpdateCultureSource is FieldCode.")
    public String getFieldUpdateCultureName() {
        return this.fieldUpdateCultureName;
    }

    public FieldOptions fieldUpdateCultureName(String fieldUpdateCultureName) {
        this.fieldUpdateCultureName = fieldUpdateCultureName;
        return this;
    }

    public void setFieldUpdateCultureName(String fieldUpdateCultureName) {
        this.fieldUpdateCultureName = fieldUpdateCultureName;
    }

    @ApiModelProperty(value="Gets or sets Field Update Culture Source.")
    public FieldUpdateCultureSourceEnum getFieldUpdateCultureSource() {
        return this.fieldUpdateCultureSource;
    }

    public FieldOptions fieldUpdateCultureSource(FieldUpdateCultureSourceEnum fieldUpdateCultureSource) {
        this.fieldUpdateCultureSource = fieldUpdateCultureSource;
        return this;
    }

    public void setFieldUpdateCultureSource(FieldUpdateCultureSourceEnum fieldUpdateCultureSource) {
        this.fieldUpdateCultureSource = fieldUpdateCultureSource;
    }

    @ApiModelProperty(value="Gets or sets File Name.")
    public String getFileName() {
        return this.fileName;
    }

    public FieldOptions fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ApiModelProperty(value="Gets or sets if Bidi Text Supported OnUpdate.")
    public Boolean getIsBidiTextSupportedOnUpdate() {
        return this.isBidiTextSupportedOnUpdate;
    }

    public FieldOptions isBidiTextSupportedOnUpdate(Boolean isBidiTextSupportedOnUpdate) {
        this.isBidiTextSupportedOnUpdate = isBidiTextSupportedOnUpdate;
        return this;
    }

    public void setIsBidiTextSupportedOnUpdate(Boolean isBidiTextSupportedOnUpdate) {
        this.isBidiTextSupportedOnUpdate = isBidiTextSupportedOnUpdate;
    }

    @ApiModelProperty(value="Gets or sets if Legacy Number Format.")
    public Boolean getLegacyNumberFormat() {
        return this.legacyNumberFormat;
    }

    public FieldOptions legacyNumberFormat(Boolean legacyNumberFormat) {
        this.legacyNumberFormat = legacyNumberFormat;
        return this;
    }

    public void setLegacyNumberFormat(Boolean legacyNumberFormat) {
        this.legacyNumberFormat = legacyNumberFormat;
    }

    @ApiModelProperty(value="Gets or sets PreProcess Culture Name. It is a culture code for DOC fields.")
    public String getPreProcessCultureName() {
        return this.preProcessCultureName;
    }

    public FieldOptions preProcessCultureName(String preProcessCultureName) {
        this.preProcessCultureName = preProcessCultureName;
        return this;
    }

    public void setPreProcessCultureName(String preProcessCultureName) {
        this.preProcessCultureName = preProcessCultureName;
    }

    @ApiModelProperty(value="Gets or sets Template Name.")
    public String getTemplateName() {
        return this.templateName;
    }

    public FieldOptions templateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @ApiModelProperty(value="Gets or sets if Use Invariant Culture Number Format.")
    public Boolean getUseInvariantCultureNumberFormat() {
        return this.useInvariantCultureNumberFormat;
    }

    public FieldOptions useInvariantCultureNumberFormat(Boolean useInvariantCultureNumberFormat) {
        this.useInvariantCultureNumberFormat = useInvariantCultureNumberFormat;
        return this;
    }

    public void setUseInvariantCultureNumberFormat(Boolean useInvariantCultureNumberFormat) {
        this.useInvariantCultureNumberFormat = useInvariantCultureNumberFormat;
    }

    @ApiModelProperty(value="Gets or sets BuiltIn Templates Paths.")
    public List<String> getBuiltInTemplatesPaths() {
        return this.builtInTemplatesPaths;
    }

    public FieldOptions builtInTemplatesPaths(List<String> builtInTemplatesPaths) {
        this.builtInTemplatesPaths = builtInTemplatesPaths;
        return this;
    }

    public FieldOptions addBuiltInTemplatesPathsItem(String builtInTemplatesPathsItem) {
        if (this.builtInTemplatesPaths == null) {
            this.builtInTemplatesPaths = new ArrayList<String>();
        }
        this.builtInTemplatesPaths.add(builtInTemplatesPathsItem);
        return this;
    }

    public void setBuiltInTemplatesPaths(List<String> builtInTemplatesPaths) {
        this.builtInTemplatesPaths = builtInTemplatesPaths;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.currentUser != null) {
            this.currentUser.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldOptions fieldOptions = (FieldOptions)o;
        return Objects.equals(this.currentUser, fieldOptions.currentUser) && Objects.equals(this.customTocStyleSeparator, fieldOptions.customTocStyleSeparator) && Objects.equals(this.defaultDocumentAuthor, fieldOptions.defaultDocumentAuthor) && Objects.equals((Object)this.fieldIndexFormat, (Object)fieldOptions.fieldIndexFormat) && Objects.equals(this.fieldUpdateCultureName, fieldOptions.fieldUpdateCultureName) && Objects.equals((Object)this.fieldUpdateCultureSource, (Object)fieldOptions.fieldUpdateCultureSource) && Objects.equals(this.fileName, fieldOptions.fileName) && Objects.equals(this.isBidiTextSupportedOnUpdate, fieldOptions.isBidiTextSupportedOnUpdate) && Objects.equals(this.legacyNumberFormat, fieldOptions.legacyNumberFormat) && Objects.equals(this.preProcessCultureName, fieldOptions.preProcessCultureName) && Objects.equals(this.templateName, fieldOptions.templateName) && Objects.equals(this.useInvariantCultureNumberFormat, fieldOptions.useInvariantCultureNumberFormat) && Objects.equals(this.builtInTemplatesPaths, fieldOptions.builtInTemplatesPaths);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentUser, this.customTocStyleSeparator, this.defaultDocumentAuthor, this.fieldIndexFormat, this.fieldUpdateCultureName, this.fieldUpdateCultureSource, this.fileName, this.isBidiTextSupportedOnUpdate, this.legacyNumberFormat, this.preProcessCultureName, this.templateName, this.useInvariantCultureNumberFormat, this.builtInTemplatesPaths});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldOptions {\n");
        sb.append("    currentUser: ").append(this.toIndentedString(this.getCurrentUser())).append("\n");
        sb.append("    customTocStyleSeparator: ").append(this.toIndentedString(this.getCustomTocStyleSeparator())).append("\n");
        sb.append("    defaultDocumentAuthor: ").append(this.toIndentedString(this.getDefaultDocumentAuthor())).append("\n");
        sb.append("    fieldIndexFormat: ").append(this.toIndentedString((Object)this.getFieldIndexFormat())).append("\n");
        sb.append("    fieldUpdateCultureName: ").append(this.toIndentedString(this.getFieldUpdateCultureName())).append("\n");
        sb.append("    fieldUpdateCultureSource: ").append(this.toIndentedString((Object)this.getFieldUpdateCultureSource())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    isBidiTextSupportedOnUpdate: ").append(this.toIndentedString(this.getIsBidiTextSupportedOnUpdate())).append("\n");
        sb.append("    legacyNumberFormat: ").append(this.toIndentedString(this.getLegacyNumberFormat())).append("\n");
        sb.append("    preProcessCultureName: ").append(this.toIndentedString(this.getPreProcessCultureName())).append("\n");
        sb.append("    templateName: ").append(this.toIndentedString(this.getTemplateName())).append("\n");
        sb.append("    useInvariantCultureNumberFormat: ").append(this.toIndentedString(this.getUseInvariantCultureNumberFormat())).append("\n");
        sb.append("    builtInTemplatesPaths: ").append(this.toIndentedString(this.getBuiltInTemplatesPaths())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FieldIndexFormatEnum {
        TEMPLATE("Template"),
        CLASSIC("Classic"),
        FANCY("Fancy"),
        MODERN("Modern"),
        BULLETED("Bulleted"),
        FORMAL("Formal"),
        SIMPLE("Simple");

        private String value;

        private FieldIndexFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FieldIndexFormatEnum fromValue(String text) {
            for (FieldIndexFormatEnum b : FieldIndexFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FieldIndexFormatEnum> {
            public void write(JsonWriter jsonWriter, FieldIndexFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FieldIndexFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FieldIndexFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FieldUpdateCultureSourceEnum {
        CURRENTTHREAD("CurrentThread"),
        FIELDCODE("FieldCode");

        private String value;

        private FieldUpdateCultureSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FieldUpdateCultureSourceEnum fromValue(String text) {
            for (FieldUpdateCultureSourceEnum b : FieldUpdateCultureSourceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FieldUpdateCultureSourceEnum> {
            public void write(JsonWriter jsonWriter, FieldUpdateCultureSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FieldUpdateCultureSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FieldUpdateCultureSourceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

