/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.DocumentPosition;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FootnoteLink;
import com.aspose.words.cloud.model.StoryChildNodes;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a footnote.")
public class Footnote
extends FootnoteLink {
    @SerializedName(value="Position")
    protected DocumentPosition position = null;
    @SerializedName(value="FootnoteType")
    protected FootnoteTypeEnum footnoteType = null;
    @SerializedName(value="ReferenceMark")
    protected String referenceMark = null;
    @SerializedName(value="Text")
    protected String text = null;
    @SerializedName(value="Content")
    protected StoryChildNodes content = null;

    @ApiModelProperty(value="Gets or sets the link to comment range start node.")
    public DocumentPosition getPosition() {
        return this.position;
    }

    public Footnote position(DocumentPosition position) {
        this.position = position;
        return this;
    }

    public void setPosition(DocumentPosition position) {
        this.position = position;
    }

    @ApiModelProperty(value="Gets or sets the value, that specifies whether this is a footnote or endnote.")
    public FootnoteTypeEnum getFootnoteType() {
        return this.footnoteType;
    }

    public Footnote footnoteType(FootnoteTypeEnum footnoteType) {
        this.footnoteType = footnoteType;
        return this;
    }

    public void setFootnoteType(FootnoteTypeEnum footnoteType) {
        this.footnoteType = footnoteType;
    }

    @ApiModelProperty(value="Gets or sets the custom reference mark to be used for this footnote. The default value is Empty, meaning auto-numbered footnotes are used. RTF-format can only store 1 symbol as custom reference mark, so upon export only the first symbol will be written others will be discard.")
    public String getReferenceMark() {
        return this.referenceMark;
    }

    public Footnote referenceMark(String referenceMark) {
        this.referenceMark = referenceMark;
        return this;
    }

    public void setReferenceMark(String referenceMark) {
        this.referenceMark = referenceMark;
    }

    @ApiModelProperty(value="Gets or sets text of the footnote. This method allows to quickly set text of a footnote from a string. The string can contain paragraph breaks, this will create paragraphs of text in the footnote accordingly.")
    public String getText() {
        return this.text;
    }

    public Footnote text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Gets or sets the content of the footnote.")
    public StoryChildNodes getContent() {
        return this.content;
    }

    public Footnote content(StoryChildNodes content) {
        this.content = content;
        return this;
    }

    public void setContent(StoryChildNodes content) {
        this.content = content;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.position != null) {
            this.position.validate();
        }
        if (this.content != null) {
            this.content.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Footnote footnote = (Footnote)o;
        return Objects.equals(this.position, footnote.position) && Objects.equals((Object)this.footnoteType, (Object)footnote.footnoteType) && Objects.equals(this.referenceMark, footnote.referenceMark) && Objects.equals(this.text, footnote.text) && Objects.equals(this.content, footnote.content) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.footnoteType, this.referenceMark, this.text, this.content, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Footnote {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("    footnoteType: ").append(this.toIndentedString((Object)this.getFootnoteType())).append("\n");
        sb.append("    referenceMark: ").append(this.toIndentedString(this.getReferenceMark())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.getContent())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FootnoteTypeEnum {
        FOOTNOTE("Footnote"),
        ENDNOTE("Endnote");

        private String value;

        private FootnoteTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FootnoteTypeEnum fromValue(String text) {
            for (FootnoteTypeEnum b : FootnoteTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FootnoteTypeEnum> {
            public void write(JsonWriter jsonWriter, FootnoteTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FootnoteTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FootnoteTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

