/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FormField;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="FormField checkbox element.")
public class FormFieldCheckbox
extends FormField {
    @SerializedName(value="IsCheckBoxExactSize")
    protected Boolean isCheckBoxExactSize = null;
    @SerializedName(value="CheckBoxSize")
    protected Double checkBoxSize = null;
    @SerializedName(value="Checked")
    protected Boolean checked = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether the size of the textbox is automatic or specified explicitly.")
    public Boolean getIsCheckBoxExactSize() {
        return this.isCheckBoxExactSize;
    }

    public FormFieldCheckbox isCheckBoxExactSize(Boolean isCheckBoxExactSize) {
        this.isCheckBoxExactSize = isCheckBoxExactSize;
        return this;
    }

    public void setIsCheckBoxExactSize(Boolean isCheckBoxExactSize) {
        this.isCheckBoxExactSize = isCheckBoxExactSize;
    }

    @ApiModelProperty(value="Gets or sets the size of the checkbox in points. Has effect only when IsCheckBoxExactSize is true.")
    public Double getCheckBoxSize() {
        return this.checkBoxSize;
    }

    public FormFieldCheckbox checkBoxSize(Double checkBoxSize) {
        this.checkBoxSize = checkBoxSize;
        return this;
    }

    public void setCheckBoxSize(Double checkBoxSize) {
        this.checkBoxSize = checkBoxSize;
    }

    @ApiModelProperty(value="Gets or sets the checked status of the check box form field.")
    public Boolean getChecked() {
        return this.checked;
    }

    public FormFieldCheckbox checked(Boolean checked) {
        this.checked = checked;
        return this;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.checked == null) {
            throw new ApiException(400, "Property Checked in FormFieldCheckbox is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormFieldCheckbox formFieldCheckbox = (FormFieldCheckbox)o;
        return Objects.equals(this.isCheckBoxExactSize, formFieldCheckbox.isCheckBoxExactSize) && Objects.equals(this.checkBoxSize, formFieldCheckbox.checkBoxSize) && Objects.equals(this.checked, formFieldCheckbox.checked) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isCheckBoxExactSize, this.checkBoxSize, this.checked, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormFieldCheckbox {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.getEnabled())).append("\n");
        sb.append("    statusText: ").append(this.toIndentedString(this.getStatusText())).append("\n");
        sb.append("    ownStatus: ").append(this.toIndentedString(this.getOwnStatus())).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.getHelpText())).append("\n");
        sb.append("    ownHelp: ").append(this.toIndentedString(this.getOwnHelp())).append("\n");
        sb.append("    calculateOnExit: ").append(this.toIndentedString(this.getCalculateOnExit())).append("\n");
        sb.append("    entryMacro: ").append(this.toIndentedString(this.getEntryMacro())).append("\n");
        sb.append("    exitMacro: ").append(this.toIndentedString(this.getExitMacro())).append("\n");
        sb.append("    isCheckBoxExactSize: ").append(this.toIndentedString(this.getIsCheckBoxExactSize())).append("\n");
        sb.append("    checkBoxSize: ").append(this.toIndentedString(this.getCheckBoxSize())).append("\n");
        sb.append("    checked: ").append(this.toIndentedString(this.getChecked())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

