/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FixedPageSaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for fixed html save options.")
public class HtmlFixedSaveOptionsData
extends FixedPageSaveOptionsData {
    @SerializedName(value="CssClassNamesPrefix")
    protected String cssClassNamesPrefix = null;
    @SerializedName(value="Encoding")
    protected String encoding = null;
    @SerializedName(value="ExportEmbeddedCss")
    protected Boolean exportEmbeddedCss = null;
    @SerializedName(value="ExportEmbeddedFonts")
    protected Boolean exportEmbeddedFonts = null;
    @SerializedName(value="ExportEmbeddedImages")
    protected Boolean exportEmbeddedImages = null;
    @SerializedName(value="ExportFormFields")
    protected Boolean exportFormFields = null;
    @SerializedName(value="FontFormat")
    protected FontFormatEnum fontFormat = null;
    @SerializedName(value="IdPrefix")
    protected String idPrefix = null;
    @SerializedName(value="PageHorizontalAlignment")
    protected PageHorizontalAlignmentEnum pageHorizontalAlignment = null;
    @SerializedName(value="PageMargins")
    protected Double pageMargins = null;
    @SerializedName(value="ResourcesFolder")
    protected String resourcesFolder = null;
    @SerializedName(value="ResourcesFolderAlias")
    protected String resourcesFolderAlias = null;
    @SerializedName(value="SaveFontFaceCssSeparately")
    protected Boolean saveFontFaceCssSeparately = null;
    @SerializedName(value="ShowPageBorder")
    protected Boolean showPageBorder = null;
    @SerializedName(value="UseTargetMachineFonts")
    protected Boolean useTargetMachineFonts = null;

    @ApiModelProperty(value="Gets or sets the prefix which is added to all class names in style.css file. The default value is \"aw\".")
    public String getCssClassNamesPrefix() {
        return this.cssClassNamesPrefix;
    }

    public HtmlFixedSaveOptionsData cssClassNamesPrefix(String cssClassNamesPrefix) {
        this.cssClassNamesPrefix = cssClassNamesPrefix;
        return this;
    }

    public void setCssClassNamesPrefix(String cssClassNamesPrefix) {
        this.cssClassNamesPrefix = cssClassNamesPrefix;
    }

    @ApiModelProperty(value="Gets or sets the character encoding.")
    public String getEncoding() {
        return this.encoding;
    }

    public HtmlFixedSaveOptionsData encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the CSS (Cascading Style Sheet) should be embedded into the Html document.")
    public Boolean getExportEmbeddedCss() {
        return this.exportEmbeddedCss;
    }

    public HtmlFixedSaveOptionsData exportEmbeddedCss(Boolean exportEmbeddedCss) {
        this.exportEmbeddedCss = exportEmbeddedCss;
        return this;
    }

    public void setExportEmbeddedCss(Boolean exportEmbeddedCss) {
        this.exportEmbeddedCss = exportEmbeddedCss;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fonts should be embedded into the Html document in Base64 format.")
    public Boolean getExportEmbeddedFonts() {
        return this.exportEmbeddedFonts;
    }

    public HtmlFixedSaveOptionsData exportEmbeddedFonts(Boolean exportEmbeddedFonts) {
        this.exportEmbeddedFonts = exportEmbeddedFonts;
        return this;
    }

    public void setExportEmbeddedFonts(Boolean exportEmbeddedFonts) {
        this.exportEmbeddedFonts = exportEmbeddedFonts;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether images should be embedded into the Html document in Base64 format.")
    public Boolean getExportEmbeddedImages() {
        return this.exportEmbeddedImages;
    }

    public HtmlFixedSaveOptionsData exportEmbeddedImages(Boolean exportEmbeddedImages) {
        this.exportEmbeddedImages = exportEmbeddedImages;
        return this;
    }

    public void setExportEmbeddedImages(Boolean exportEmbeddedImages) {
        this.exportEmbeddedImages = exportEmbeddedImages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether form fields are exported as interactive items (as 'input' tag) rather than converted to text or graphics.")
    public Boolean getExportFormFields() {
        return this.exportFormFields;
    }

    public HtmlFixedSaveOptionsData exportFormFields(Boolean exportFormFields) {
        this.exportFormFields = exportFormFields;
        return this;
    }

    public void setExportFormFields(Boolean exportFormFields) {
        this.exportFormFields = exportFormFields;
    }

    @ApiModelProperty(value="Gets or sets the export format of fonts.")
    public FontFormatEnum getFontFormat() {
        return this.fontFormat;
    }

    public HtmlFixedSaveOptionsData fontFormat(FontFormatEnum fontFormat) {
        this.fontFormat = fontFormat;
        return this;
    }

    public void setFontFormat(FontFormatEnum fontFormat) {
        this.fontFormat = fontFormat;
    }

    @ApiModelProperty(value="Gets or sets a prefix that is prepended to all generated element IDs in the output document. The default value is null and no prefix is prepended. If the prefix is specified, it can contain only letters, digits, underscores, and hyphens, and must start with a letter.")
    public String getIdPrefix() {
        return this.idPrefix;
    }

    public HtmlFixedSaveOptionsData idPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
        return this;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    @ApiModelProperty(value="Gets or sets the horizontal alignment of pages in the HTML document. The default value is HtmlFixedHorizontalPageAlignment.Center.")
    public PageHorizontalAlignmentEnum getPageHorizontalAlignment() {
        return this.pageHorizontalAlignment;
    }

    public HtmlFixedSaveOptionsData pageHorizontalAlignment(PageHorizontalAlignmentEnum pageHorizontalAlignment) {
        this.pageHorizontalAlignment = pageHorizontalAlignment;
        return this;
    }

    public void setPageHorizontalAlignment(PageHorizontalAlignmentEnum pageHorizontalAlignment) {
        this.pageHorizontalAlignment = pageHorizontalAlignment;
    }

    @ApiModelProperty(value="Gets or sets the margin around pages in HTML document. The margins value is measured in points and should be equal to or greater than 0. The default value is 10 points. Depends on the value of PageHorizontalAlignment property: Defines top, bottom and left page margins if the value is Left. Defines top, bottom and right page margins if the value is Right. Defines top and bottom page margins if the value is Center.")
    public Double getPageMargins() {
        return this.pageMargins;
    }

    public HtmlFixedSaveOptionsData pageMargins(Double pageMargins) {
        this.pageMargins = pageMargins;
        return this;
    }

    public void setPageMargins(Double pageMargins) {
        this.pageMargins = pageMargins;
    }

    @ApiModelProperty(value="Gets or sets the physical folder where resources are saved when exporting the document.")
    public String getResourcesFolder() {
        return this.resourcesFolder;
    }

    public HtmlFixedSaveOptionsData resourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
        return this;
    }

    public void setResourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct resource URIs.")
    public String getResourcesFolderAlias() {
        return this.resourcesFolderAlias;
    }

    public HtmlFixedSaveOptionsData resourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
        return this;
    }

    public void setResourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether \"@font-face\" CSS rules should be placed into a separate file \"fontFaces.css\" when a document is being saved with external stylesheet (that is, when Aspose.Words.Saving.HtmlFixedSaveOptions.ExportEmbeddedCss is false). The default value is false, all CSS rules are written into single file \"styles.css\". Setting this property to true restores the old behavior (separate files) for compatibility with legacy code.")
    public Boolean getSaveFontFaceCssSeparately() {
        return this.saveFontFaceCssSeparately;
    }

    public HtmlFixedSaveOptionsData saveFontFaceCssSeparately(Boolean saveFontFaceCssSeparately) {
        this.saveFontFaceCssSeparately = saveFontFaceCssSeparately;
        return this;
    }

    public void setSaveFontFaceCssSeparately(Boolean saveFontFaceCssSeparately) {
        this.saveFontFaceCssSeparately = saveFontFaceCssSeparately;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to show border around pages.")
    public Boolean getShowPageBorder() {
        return this.showPageBorder;
    }

    public HtmlFixedSaveOptionsData showPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
        return this;
    }

    public void setShowPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fonts from target machine must be used to display the document. If this flag is set to true, Aspose.Words.Saving.HtmlFixedSaveOptions.FontFormat and Aspose.Words.Saving.HtmlFixedSaveOptions.ExportEmbeddedFonts properties do not have effect, also Aspose.Words.Saving.HtmlFixedSaveOptions.ResourceSavingCallback is not fired for fonts. The default value is false.")
    public Boolean getUseTargetMachineFonts() {
        return this.useTargetMachineFonts;
    }

    public HtmlFixedSaveOptionsData useTargetMachineFonts(Boolean useTargetMachineFonts) {
        this.useTargetMachineFonts = useTargetMachineFonts;
        return this;
    }

    public void setUseTargetMachineFonts(Boolean useTargetMachineFonts) {
        this.useTargetMachineFonts = useTargetMachineFonts;
    }

    public HtmlFixedSaveOptionsData() {
        this.saveFormat = "htmlfixed";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlFixedSaveOptionsData htmlFixedSaveOptionsData = (HtmlFixedSaveOptionsData)o;
        return Objects.equals(this.cssClassNamesPrefix, htmlFixedSaveOptionsData.cssClassNamesPrefix) && Objects.equals(this.encoding, htmlFixedSaveOptionsData.encoding) && Objects.equals(this.exportEmbeddedCss, htmlFixedSaveOptionsData.exportEmbeddedCss) && Objects.equals(this.exportEmbeddedFonts, htmlFixedSaveOptionsData.exportEmbeddedFonts) && Objects.equals(this.exportEmbeddedImages, htmlFixedSaveOptionsData.exportEmbeddedImages) && Objects.equals(this.exportFormFields, htmlFixedSaveOptionsData.exportFormFields) && Objects.equals((Object)this.fontFormat, (Object)htmlFixedSaveOptionsData.fontFormat) && Objects.equals(this.idPrefix, htmlFixedSaveOptionsData.idPrefix) && Objects.equals((Object)this.pageHorizontalAlignment, (Object)htmlFixedSaveOptionsData.pageHorizontalAlignment) && Objects.equals(this.pageMargins, htmlFixedSaveOptionsData.pageMargins) && Objects.equals(this.resourcesFolder, htmlFixedSaveOptionsData.resourcesFolder) && Objects.equals(this.resourcesFolderAlias, htmlFixedSaveOptionsData.resourcesFolderAlias) && Objects.equals(this.saveFontFaceCssSeparately, htmlFixedSaveOptionsData.saveFontFaceCssSeparately) && Objects.equals(this.showPageBorder, htmlFixedSaveOptionsData.showPageBorder) && Objects.equals(this.useTargetMachineFonts, htmlFixedSaveOptionsData.useTargetMachineFonts) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cssClassNamesPrefix, this.encoding, this.exportEmbeddedCss, this.exportEmbeddedFonts, this.exportEmbeddedImages, this.exportFormFields, this.fontFormat, this.idPrefix, this.pageHorizontalAlignment, this.pageMargins, this.resourcesFolder, this.resourcesFolderAlias, this.saveFontFaceCssSeparately, this.showPageBorder, this.useTargetMachineFonts, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HtmlFixedSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    cssClassNamesPrefix: ").append(this.toIndentedString(this.getCssClassNamesPrefix())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.getEncoding())).append("\n");
        sb.append("    exportEmbeddedCss: ").append(this.toIndentedString(this.getExportEmbeddedCss())).append("\n");
        sb.append("    exportEmbeddedFonts: ").append(this.toIndentedString(this.getExportEmbeddedFonts())).append("\n");
        sb.append("    exportEmbeddedImages: ").append(this.toIndentedString(this.getExportEmbeddedImages())).append("\n");
        sb.append("    exportFormFields: ").append(this.toIndentedString(this.getExportFormFields())).append("\n");
        sb.append("    fontFormat: ").append(this.toIndentedString((Object)this.getFontFormat())).append("\n");
        sb.append("    idPrefix: ").append(this.toIndentedString(this.getIdPrefix())).append("\n");
        sb.append("    pageHorizontalAlignment: ").append(this.toIndentedString((Object)this.getPageHorizontalAlignment())).append("\n");
        sb.append("    pageMargins: ").append(this.toIndentedString(this.getPageMargins())).append("\n");
        sb.append("    resourcesFolder: ").append(this.toIndentedString(this.getResourcesFolder())).append("\n");
        sb.append("    resourcesFolderAlias: ").append(this.toIndentedString(this.getResourcesFolderAlias())).append("\n");
        sb.append("    saveFontFaceCssSeparately: ").append(this.toIndentedString(this.getSaveFontFaceCssSeparately())).append("\n");
        sb.append("    showPageBorder: ").append(this.toIndentedString(this.getShowPageBorder())).append("\n");
        sb.append("    useTargetMachineFonts: ").append(this.toIndentedString(this.getUseTargetMachineFonts())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FontFormatEnum {
        WOFF("Woff"),
        TTF("Ttf");

        private String value;

        private FontFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FontFormatEnum fromValue(String text) {
            for (FontFormatEnum b : FontFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FontFormatEnum> {
            public void write(JsonWriter jsonWriter, FontFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FontFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FontFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageHorizontalAlignmentEnum {
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private PageHorizontalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageHorizontalAlignmentEnum fromValue(String text) {
            for (PageHorizontalAlignmentEnum b : PageHorizontalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageHorizontalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, PageHorizontalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageHorizontalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageHorizontalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

