/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides information for the object link. This is supposed to be an atom:link, therefore it should have all attributes specified here http://tools.ietf.org/html/rfc4287#section-4.2.7.")
public class Link
implements ModelIfc {
    @SerializedName(value="Href")
    protected String href = null;
    @SerializedName(value="Rel")
    protected String rel = null;
    @SerializedName(value="Title")
    protected String title = null;
    @SerializedName(value="Type")
    protected String type = null;

    @ApiModelProperty(value="Gets or sets the \"href\" attribute with the link's IRI. atom:link elements MUST have an href attribute, whose value MUST be a IRI reference.")
    public String getHref() {
        return this.href;
    }

    public Link href(String href) {
        this.href = href;
        return this;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @ApiModelProperty(value="Gets or sets the option that controls whether atom:link elements MAY have a \"rel\" attribute that indicates the link relation type.  If the \"rel\" attribute is not present, the link element MUST be interpreted as if the link relation type is \"alternate\".")
    public String getRel() {
        return this.rel;
    }

    public Link rel(String rel) {
        this.rel = rel;
        return this;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    @ApiModelProperty(value="Gets or sets the \"title\" attribute, that conveys human-readable information about the link. The content of the \"title\" attribute is Language-Sensitive.")
    public String getTitle() {
        return this.title;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @ApiModelProperty(value="Gets or sets the \"type\" attribute. The \"type\" attribute's value is an advisory media type: it is a hint about the type of the representation that is expected to be returned when the value of the href attribute is dereferenced. Note that the type attribute does not override the actual media type returned with the representation.")
    public String getType() {
        return this.type;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.href, link.href) && Objects.equals(this.rel, link.rel) && Objects.equals(this.title, link.title) && Objects.equals(this.type, link.type);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.rel, this.title, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    href: ").append(this.toIndentedString(this.getHref())).append("\n");
        sb.append("    rel: ").append(this.toIndentedString(this.getRel())).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.getTitle())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.getType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

