/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.Font;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.Style;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a document list level.")
public class ListLevel
extends LinkElement {
    @SerializedName(value="StartAt")
    protected Integer startAt = null;
    @SerializedName(value="NumberStyle")
    protected NumberStyleEnum numberStyle = null;
    @SerializedName(value="NumberFormat")
    protected String numberFormat = null;
    @SerializedName(value="Alignment")
    protected AlignmentEnum alignment = null;
    @SerializedName(value="IsLegal")
    protected Boolean isLegal = null;
    @SerializedName(value="RestartAfterLevel")
    protected Integer restartAfterLevel = null;
    @SerializedName(value="TrailingCharacter")
    protected TrailingCharacterEnum trailingCharacter = null;
    @SerializedName(value="Font")
    protected Font font = null;
    @SerializedName(value="TabPosition")
    protected Double tabPosition = null;
    @SerializedName(value="NumberPosition")
    protected Double numberPosition = null;
    @SerializedName(value="TextPosition")
    protected Double textPosition = null;
    @SerializedName(value="LinkedStyle")
    protected Style linkedStyle = null;

    @ApiModelProperty(value="Gets or sets the starting number for this list level. The default value is 1.")
    public Integer getStartAt() {
        return this.startAt;
    }

    public ListLevel startAt(Integer startAt) {
        this.startAt = startAt;
        return this;
    }

    public void setStartAt(Integer startAt) {
        this.startAt = startAt;
    }

    @ApiModelProperty(value="Gets or sets the number style for this list level.")
    public NumberStyleEnum getNumberStyle() {
        return this.numberStyle;
    }

    public ListLevel numberStyle(NumberStyleEnum numberStyle) {
        this.numberStyle = numberStyle;
        return this;
    }

    public void setNumberStyle(NumberStyleEnum numberStyle) {
        this.numberStyle = numberStyle;
    }

    @ApiModelProperty(value="Gets or sets the number format for the list level. Among normal text characters, the string can contain placeholder characters \\x0000 to \\x0008 representing the numbers from the corresponding list levels. For example, the string \"\\x0000.\\x0001)\" will generate a list label that looks something like \"1.5)\". The number \"1\" is the current number from the 1st list level, the number \"5\" is the current number from the 2nd list level. Null is not allowed, but an empty string meaning no number is valid.")
    public String getNumberFormat() {
        return this.numberFormat;
    }

    public ListLevel numberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
        return this;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    @ApiModelProperty(value="Gets or sets the justification of the actual number of the list item. The list label is justified relative to the Aspose.Words.Lists.ListLevel.NumberPosition property.")
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    public ListLevel alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the level turns all inherited numbers to Arabic, false if it preserves their number style.")
    public Boolean getIsLegal() {
        return this.isLegal;
    }

    public ListLevel isLegal(Boolean isLegal) {
        this.isLegal = isLegal;
        return this;
    }

    public void setIsLegal(Boolean isLegal) {
        this.isLegal = isLegal;
    }

    @ApiModelProperty(value="Gets or sets the list level, that must appear before the specified list level restarts numbering. The value of -1 means the numbering will continue.")
    public Integer getRestartAfterLevel() {
        return this.restartAfterLevel;
    }

    public ListLevel restartAfterLevel(Integer restartAfterLevel) {
        this.restartAfterLevel = restartAfterLevel;
        return this;
    }

    public void setRestartAfterLevel(Integer restartAfterLevel) {
        this.restartAfterLevel = restartAfterLevel;
    }

    @ApiModelProperty(value="Gets or sets the character inserted after the number for the list level.")
    public TrailingCharacterEnum getTrailingCharacter() {
        return this.trailingCharacter;
    }

    public ListLevel trailingCharacter(TrailingCharacterEnum trailingCharacter) {
        this.trailingCharacter = trailingCharacter;
        return this;
    }

    public void setTrailingCharacter(TrailingCharacterEnum trailingCharacter) {
        this.trailingCharacter = trailingCharacter;
    }

    @ApiModelProperty(value="Gets or sets character formatting used for the list label.")
    public Font getFont() {
        return this.font;
    }

    public ListLevel font(Font font) {
        this.font = font;
        return this;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @ApiModelProperty(value="Gets or sets the tab position (in points) for the list level. Has effect only when Aspose.Words.Lists.ListLevel.TrailingCharacter is a tab. Aspose.Words.Lists.ListLevel.NumberPosition Aspose.Words.Lists.ListLevel.TextPosition.")
    public Double getTabPosition() {
        return this.tabPosition;
    }

    public ListLevel tabPosition(Double tabPosition) {
        this.tabPosition = tabPosition;
        return this;
    }

    public void setTabPosition(Double tabPosition) {
        this.tabPosition = tabPosition;
    }

    @ApiModelProperty(value="Gets or sets the position (in points) of the number or bullet for the list level. Aspose.Words.Lists.ListLevel.NumberPosition corresponds to LeftIndent plus FirstLineIndent of the paragraph. Aspose.Words.Lists.ListLevel.TextPosition Aspose.Words.Lists.ListLevel.TabPosition.")
    public Double getNumberPosition() {
        return this.numberPosition;
    }

    public ListLevel numberPosition(Double numberPosition) {
        this.numberPosition = numberPosition;
        return this;
    }

    public void setNumberPosition(Double numberPosition) {
        this.numberPosition = numberPosition;
    }

    @ApiModelProperty(value="Gets or sets the position (in points) for the second line of wrapping text for the list level. Aspose.Words.Lists.ListLevel.TextPosition corresponds to LeftIndent of the paragraph. Aspose.Words.Lists.ListLevel.NumberPosition Aspose.Words.Lists.ListLevel.TabPosition.")
    public Double getTextPosition() {
        return this.textPosition;
    }

    public ListLevel textPosition(Double textPosition) {
        this.textPosition = textPosition;
        return this;
    }

    public void setTextPosition(Double textPosition) {
        this.textPosition = textPosition;
    }

    @ApiModelProperty(value="Gets or sets the paragraph style that is linked to this list level. This property is null when the list level is not linked to a paragraph style. This property can be set to null.")
    public Style getLinkedStyle() {
        return this.linkedStyle;
    }

    public ListLevel linkedStyle(Style linkedStyle) {
        this.linkedStyle = linkedStyle;
        return this;
    }

    public void setLinkedStyle(Style linkedStyle) {
        this.linkedStyle = linkedStyle;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.startAt == null) {
            throw new ApiException(400, "Property StartAt in ListLevel is required.");
        }
        if (this.numberStyle == null) {
            throw new ApiException(400, "Property NumberStyle in ListLevel is required.");
        }
        if (this.alignment == null) {
            throw new ApiException(400, "Property Alignment in ListLevel is required.");
        }
        if (this.isLegal == null) {
            throw new ApiException(400, "Property IsLegal in ListLevel is required.");
        }
        if (this.restartAfterLevel == null) {
            throw new ApiException(400, "Property RestartAfterLevel in ListLevel is required.");
        }
        if (this.trailingCharacter == null) {
            throw new ApiException(400, "Property TrailingCharacter in ListLevel is required.");
        }
        if (this.tabPosition == null) {
            throw new ApiException(400, "Property TabPosition in ListLevel is required.");
        }
        if (this.numberPosition == null) {
            throw new ApiException(400, "Property NumberPosition in ListLevel is required.");
        }
        if (this.textPosition == null) {
            throw new ApiException(400, "Property TextPosition in ListLevel is required.");
        }
        if (this.font != null) {
            this.font.validate();
        }
        if (this.linkedStyle != null) {
            this.linkedStyle.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListLevel listLevel = (ListLevel)o;
        return Objects.equals(this.startAt, listLevel.startAt) && Objects.equals((Object)this.numberStyle, (Object)listLevel.numberStyle) && Objects.equals(this.numberFormat, listLevel.numberFormat) && Objects.equals((Object)this.alignment, (Object)listLevel.alignment) && Objects.equals(this.isLegal, listLevel.isLegal) && Objects.equals(this.restartAfterLevel, listLevel.restartAfterLevel) && Objects.equals((Object)this.trailingCharacter, (Object)listLevel.trailingCharacter) && Objects.equals(this.font, listLevel.font) && Objects.equals(this.tabPosition, listLevel.tabPosition) && Objects.equals(this.numberPosition, listLevel.numberPosition) && Objects.equals(this.textPosition, listLevel.textPosition) && Objects.equals(this.linkedStyle, listLevel.linkedStyle) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.startAt, this.numberStyle, this.numberFormat, this.alignment, this.isLegal, this.restartAfterLevel, this.trailingCharacter, this.font, this.tabPosition, this.numberPosition, this.textPosition, this.linkedStyle, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListLevel {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.getStartAt())).append("\n");
        sb.append("    numberStyle: ").append(this.toIndentedString((Object)this.getNumberStyle())).append("\n");
        sb.append("    numberFormat: ").append(this.toIndentedString(this.getNumberFormat())).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.getAlignment())).append("\n");
        sb.append("    isLegal: ").append(this.toIndentedString(this.getIsLegal())).append("\n");
        sb.append("    restartAfterLevel: ").append(this.toIndentedString(this.getRestartAfterLevel())).append("\n");
        sb.append("    trailingCharacter: ").append(this.toIndentedString((Object)this.getTrailingCharacter())).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.getFont())).append("\n");
        sb.append("    tabPosition: ").append(this.toIndentedString(this.getTabPosition())).append("\n");
        sb.append("    numberPosition: ").append(this.toIndentedString(this.getNumberPosition())).append("\n");
        sb.append("    textPosition: ").append(this.toIndentedString(this.getTextPosition())).append("\n");
        sb.append("    linkedStyle: ").append(this.toIndentedString(this.getLinkedStyle())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NumberStyleEnum {
        ARABIC("Arabic"),
        UPPERCASEROMAN("UppercaseRoman"),
        LOWERCASEROMAN("LowercaseRoman"),
        UPPERCASELETTER("UppercaseLetter"),
        LOWERCASELETTER("LowercaseLetter"),
        ORDINAL("Ordinal"),
        NUMBER("Number"),
        ORDINALTEXT("OrdinalText"),
        HEX("Hex"),
        CHICAGOMANUAL("ChicagoManual"),
        KANJI("Kanji"),
        KANJIDIGIT("KanjiDigit"),
        AIUEOHALFWIDTH("AiueoHalfWidth"),
        IROHAHALFWIDTH("IrohaHalfWidth"),
        ARABICFULLWIDTH("ArabicFullWidth"),
        ARABICHALFWIDTH("ArabicHalfWidth"),
        KANJITRADITIONAL("KanjiTraditional"),
        KANJITRADITIONAL2("KanjiTraditional2"),
        NUMBERINCIRCLE("NumberInCircle"),
        DECIMALFULLWIDTH("DecimalFullWidth"),
        AIUEO("Aiueo"),
        IROHA("Iroha"),
        LEADINGZERO("LeadingZero"),
        BULLET("Bullet"),
        GANADA("Ganada"),
        CHOSUNG("Chosung"),
        GB1("GB1"),
        GB2("GB2"),
        GB3("GB3"),
        GB4("GB4"),
        ZODIAC1("Zodiac1"),
        ZODIAC2("Zodiac2"),
        ZODIAC3("Zodiac3"),
        TRADCHINNUM1("TradChinNum1"),
        TRADCHINNUM2("TradChinNum2"),
        TRADCHINNUM3("TradChinNum3"),
        TRADCHINNUM4("TradChinNum4"),
        SIMPCHINNUM1("SimpChinNum1"),
        SIMPCHINNUM2("SimpChinNum2"),
        SIMPCHINNUM3("SimpChinNum3"),
        SIMPCHINNUM4("SimpChinNum4"),
        HANJAREAD("HanjaRead"),
        HANJAREADDIGIT("HanjaReadDigit"),
        HANGUL("Hangul"),
        HANJA("Hanja"),
        HEBREW1("Hebrew1"),
        ARABIC1("Arabic1"),
        HEBREW2("Hebrew2"),
        ARABIC2("Arabic2"),
        HINDILETTER1("HindiLetter1"),
        HINDILETTER2("HindiLetter2"),
        HINDIARABIC("HindiArabic"),
        HINDICARDINALTEXT("HindiCardinalText"),
        THAILETTER("ThaiLetter"),
        THAIARABIC("ThaiArabic"),
        THAICARDINALTEXT("ThaiCardinalText"),
        VIETCARDINALTEXT("VietCardinalText"),
        NUMBERINDASH("NumberInDash"),
        LOWERCASERUSSIAN("LowercaseRussian"),
        UPPERCASERUSSIAN("UppercaseRussian"),
        NONE("None"),
        CUSTOM("Custom");

        private String value;

        private NumberStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NumberStyleEnum fromValue(String text) {
            for (NumberStyleEnum b : NumberStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NumberStyleEnum> {
            public void write(JsonWriter jsonWriter, NumberStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NumberStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NumberStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AlignmentEnum {
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AlignmentEnum fromValue(String text) {
            for (AlignmentEnum b : AlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AlignmentEnum> {
            public void write(JsonWriter jsonWriter, AlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TrailingCharacterEnum {
        TAB("Tab"),
        SPACE("Space"),
        NOTHING("Nothing");

        private String value;

        private TrailingCharacterEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TrailingCharacterEnum fromValue(String text) {
            for (TrailingCharacterEnum b : TrailingCharacterEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TrailingCharacterEnum> {
            public void write(JsonWriter jsonWriter, TrailingCharacterEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TrailingCharacterEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TrailingCharacterEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

