/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for options of metafile rendering.")
public class MetafileRenderingOptionsData
implements ModelIfc {
    @SerializedName(value="EmfPlusDualRenderingMode")
    protected EmfPlusDualRenderingModeEnum emfPlusDualRenderingMode = null;
    @SerializedName(value="EmulateRasterOperations")
    protected Boolean emulateRasterOperations = null;
    @SerializedName(value="EmulateRenderingToSizeOnPage")
    protected Boolean emulateRenderingToSizeOnPage = null;
    @SerializedName(value="EmulateRenderingToSizeOnPageResolution")
    protected Integer emulateRenderingToSizeOnPageResolution = null;
    @SerializedName(value="RenderingMode")
    protected RenderingModeEnum renderingMode = null;
    @SerializedName(value="UseEmfEmbeddedToWmf")
    protected Boolean useEmfEmbeddedToWmf = null;

    @ApiModelProperty(value="Gets or sets the option that controls how EMF+ Dual metafiles should be rendered.")
    public EmfPlusDualRenderingModeEnum getEmfPlusDualRenderingMode() {
        return this.emfPlusDualRenderingMode;
    }

    public MetafileRenderingOptionsData emfPlusDualRenderingMode(EmfPlusDualRenderingModeEnum emfPlusDualRenderingMode) {
        this.emfPlusDualRenderingMode = emfPlusDualRenderingMode;
        return this;
    }

    public void setEmfPlusDualRenderingMode(EmfPlusDualRenderingModeEnum emfPlusDualRenderingMode) {
        this.emfPlusDualRenderingMode = emfPlusDualRenderingMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the raster operations should be emulated. Specific raster operations could be used in metafiles. They can not be rendered directly to vector graphics. Emulating raster operations requires partial rasterization of the resulting vector graphics which may affect the metafile rendering performance. When this value is set to true, Aspose.Words emulates the raster operations. The resulting output maybe partially rasterized and performance might be slower. When this value is set to false, Aspose.Words does not emulate the raster operations. When Aspose.Words encounters a raster operation in a metafile it fallbacks to rendering the metafile into a bitmap by using the operating system. This option is used only when metafile is rendered as vector graphics. The default value is true.")
    public Boolean getEmulateRasterOperations() {
        return this.emulateRasterOperations;
    }

    public MetafileRenderingOptionsData emulateRasterOperations(Boolean emulateRasterOperations) {
        this.emulateRasterOperations = emulateRasterOperations;
        return this;
    }

    public void setEmulateRasterOperations(Boolean emulateRasterOperations) {
        this.emulateRasterOperations = emulateRasterOperations;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether metafile rendering emulates the display of the metafile according to the size on page or the display of the metafile in its default size.")
    public Boolean getEmulateRenderingToSizeOnPage() {
        return this.emulateRenderingToSizeOnPage;
    }

    public MetafileRenderingOptionsData emulateRenderingToSizeOnPage(Boolean emulateRenderingToSizeOnPage) {
        this.emulateRenderingToSizeOnPage = emulateRenderingToSizeOnPage;
        return this;
    }

    public void setEmulateRenderingToSizeOnPage(Boolean emulateRenderingToSizeOnPage) {
        this.emulateRenderingToSizeOnPage = emulateRenderingToSizeOnPage;
    }

    @ApiModelProperty(value="Gets or sets the resolution in pixels per inch for the emulation of metafile rendering to the size on page. This option is used only when EmulateRenderingToSizeOnPage is set to true.The default value is 96. This is a default display resolution. I.e. metafile rendering will emulate the display of the metafile in MS Word with a 100% zoom factor.")
    public Integer getEmulateRenderingToSizeOnPageResolution() {
        return this.emulateRenderingToSizeOnPageResolution;
    }

    public MetafileRenderingOptionsData emulateRenderingToSizeOnPageResolution(Integer emulateRenderingToSizeOnPageResolution) {
        this.emulateRenderingToSizeOnPageResolution = emulateRenderingToSizeOnPageResolution;
        return this;
    }

    public void setEmulateRenderingToSizeOnPageResolution(Integer emulateRenderingToSizeOnPageResolution) {
        this.emulateRenderingToSizeOnPageResolution = emulateRenderingToSizeOnPageResolution;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how metafile images should be rendered.")
    public RenderingModeEnum getRenderingMode() {
        return this.renderingMode;
    }

    public MetafileRenderingOptionsData renderingMode(RenderingModeEnum renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    public void setRenderingMode(RenderingModeEnum renderingMode) {
        this.renderingMode = renderingMode;
    }

    @ApiModelProperty(value="Gets or sets the flag, that controls how WMF metafiles with embedded EMF metafiles should be rendered.")
    public Boolean getUseEmfEmbeddedToWmf() {
        return this.useEmfEmbeddedToWmf;
    }

    public MetafileRenderingOptionsData useEmfEmbeddedToWmf(Boolean useEmfEmbeddedToWmf) {
        this.useEmfEmbeddedToWmf = useEmfEmbeddedToWmf;
        return this;
    }

    public void setUseEmfEmbeddedToWmf(Boolean useEmfEmbeddedToWmf) {
        this.useEmfEmbeddedToWmf = useEmfEmbeddedToWmf;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetafileRenderingOptionsData metafileRenderingOptionsData = (MetafileRenderingOptionsData)o;
        return Objects.equals((Object)this.emfPlusDualRenderingMode, (Object)metafileRenderingOptionsData.emfPlusDualRenderingMode) && Objects.equals(this.emulateRasterOperations, metafileRenderingOptionsData.emulateRasterOperations) && Objects.equals(this.emulateRenderingToSizeOnPage, metafileRenderingOptionsData.emulateRenderingToSizeOnPage) && Objects.equals(this.emulateRenderingToSizeOnPageResolution, metafileRenderingOptionsData.emulateRenderingToSizeOnPageResolution) && Objects.equals((Object)this.renderingMode, (Object)metafileRenderingOptionsData.renderingMode) && Objects.equals(this.useEmfEmbeddedToWmf, metafileRenderingOptionsData.useEmfEmbeddedToWmf);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.emfPlusDualRenderingMode, this.emulateRasterOperations, this.emulateRenderingToSizeOnPage, this.emulateRenderingToSizeOnPageResolution, this.renderingMode, this.useEmfEmbeddedToWmf});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetafileRenderingOptionsData {\n");
        sb.append("    emfPlusDualRenderingMode: ").append(this.toIndentedString((Object)this.getEmfPlusDualRenderingMode())).append("\n");
        sb.append("    emulateRasterOperations: ").append(this.toIndentedString(this.getEmulateRasterOperations())).append("\n");
        sb.append("    emulateRenderingToSizeOnPage: ").append(this.toIndentedString(this.getEmulateRenderingToSizeOnPage())).append("\n");
        sb.append("    emulateRenderingToSizeOnPageResolution: ").append(this.toIndentedString(this.getEmulateRenderingToSizeOnPageResolution())).append("\n");
        sb.append("    renderingMode: ").append(this.toIndentedString((Object)this.getRenderingMode())).append("\n");
        sb.append("    useEmfEmbeddedToWmf: ").append(this.toIndentedString(this.getUseEmfEmbeddedToWmf())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EmfPlusDualRenderingModeEnum {
        EMFPLUSWITHFALLBACK("EmfPlusWithFallback"),
        EMFPLUS("EmfPlus"),
        EMF("Emf");

        private String value;

        private EmfPlusDualRenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EmfPlusDualRenderingModeEnum fromValue(String text) {
            for (EmfPlusDualRenderingModeEnum b : EmfPlusDualRenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EmfPlusDualRenderingModeEnum> {
            public void write(JsonWriter jsonWriter, EmfPlusDualRenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EmfPlusDualRenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EmfPlusDualRenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RenderingModeEnum {
        VECTORWITHFALLBACK("VectorWithFallback"),
        VECTOR("Vector"),
        BITMAP("Bitmap");

        private String value;

        private RenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RenderingModeEnum fromValue(String text) {
            for (RenderingModeEnum b : RenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RenderingModeEnum> {
            public void write(JsonWriter jsonWriter, RenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

