/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for odt/ott save options.")
public class OdtSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="IsStrictSchema11")
    protected Boolean isStrictSchema11 = null;
    @SerializedName(value="MeasureUnit")
    protected MeasureUnitEnum measureUnit = null;
    @SerializedName(value="Password")
    protected String password = null;
    @SerializedName(value="PrettyFormat")
    protected Boolean prettyFormat = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether export should correspond to ODT specification 1.1 strictly.")
    public Boolean getIsStrictSchema11() {
        return this.isStrictSchema11;
    }

    public OdtSaveOptionsData isStrictSchema11(Boolean isStrictSchema11) {
        this.isStrictSchema11 = isStrictSchema11;
        return this;
    }

    public void setIsStrictSchema11(Boolean isStrictSchema11) {
        this.isStrictSchema11 = isStrictSchema11;
    }

    @ApiModelProperty(value="Gets or sets the units of measure to apply to document content. The default value is Aspose.Words.Saving.OdtSaveMeasureUnit.Centimeters. Open Office uses centimeters when specifying lengths, widths and other measurable formatting and content properties in documents whereas MS Office uses inches.")
    public MeasureUnitEnum getMeasureUnit() {
        return this.measureUnit;
    }

    public OdtSaveOptionsData measureUnit(MeasureUnitEnum measureUnit) {
        this.measureUnit = measureUnit;
        return this;
    }

    public void setMeasureUnit(MeasureUnitEnum measureUnit) {
        this.measureUnit = measureUnit;
    }

    @ApiModelProperty(value="Gets or sets the password to encrypt document. In order to save document without encryption this property should be null or empty string.")
    public String getPassword() {
        return this.password;
    }

    public OdtSaveOptionsData password(String password) {
        this.password = password;
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use pretty formats output.")
    public Boolean getPrettyFormat() {
        return this.prettyFormat;
    }

    public OdtSaveOptionsData prettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }

    public void setPrettyFormat(Boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    public OdtSaveOptionsData() {
        this.saveFormat = "odt";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OdtSaveOptionsData odtSaveOptionsData = (OdtSaveOptionsData)o;
        return Objects.equals(this.isStrictSchema11, odtSaveOptionsData.isStrictSchema11) && Objects.equals((Object)this.measureUnit, (Object)odtSaveOptionsData.measureUnit) && Objects.equals(this.password, odtSaveOptionsData.password) && Objects.equals(this.prettyFormat, odtSaveOptionsData.prettyFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.isStrictSchema11, this.measureUnit, this.password, this.prettyFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OdtSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    isStrictSchema11: ").append(this.toIndentedString(this.getIsStrictSchema11())).append("\n");
        sb.append("    measureUnit: ").append(this.toIndentedString((Object)this.getMeasureUnit())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.getPassword())).append("\n");
        sb.append("    prettyFormat: ").append(this.toIndentedString(this.getPrettyFormat())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MeasureUnitEnum {
        CENTIMETERS("Centimeters"),
        INCHES("Inches");

        private String value;

        private MeasureUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MeasureUnitEnum fromValue(String text) {
            for (MeasureUnitEnum b : MeasureUnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MeasureUnitEnum> {
            public void write(JsonWriter jsonWriter, MeasureUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MeasureUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MeasureUnitEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

