/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for the document optimization options.")
public class OptimizationOptions
implements ModelIfc {
    @SerializedName(value="MsWordVersion")
    protected MsWordVersionEnum msWordVersion = null;

    @ApiModelProperty(value="Gets or sets the specific MSWord version.")
    public MsWordVersionEnum getMsWordVersion() {
        return this.msWordVersion;
    }

    public OptimizationOptions msWordVersion(MsWordVersionEnum msWordVersion) {
        this.msWordVersion = msWordVersion;
        return this;
    }

    public void setMsWordVersion(MsWordVersionEnum msWordVersion) {
        this.msWordVersion = msWordVersion;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.msWordVersion == null) {
            throw new ApiException(400, "Property MsWordVersion in OptimizationOptions is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizationOptions optimizationOptions = (OptimizationOptions)o;
        return Objects.equals((Object)this.msWordVersion, (Object)optimizationOptions.msWordVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.msWordVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptimizationOptions {\n");
        sb.append("    msWordVersion: ").append(this.toIndentedString((Object)this.getMsWordVersion())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MsWordVersionEnum {
        WORD2000("Word2000"),
        WORD2002("Word2002"),
        WORD2003("Word2003"),
        WORD2007("Word2007"),
        WORD2010("Word2010"),
        WORD2013("Word2013"),
        WORD2016("Word2016"),
        WORD2019("Word2019");

        private String value;

        private MsWordVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MsWordVersionEnum fromValue(String text) {
            for (MsWordVersionEnum b : MsWordVersionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MsWordVersionEnum> {
            public void write(JsonWriter jsonWriter, MsWordVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MsWordVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MsWordVersionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

