/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Class for document replace text request building.")
public class ReplaceTextParameters
implements ModelIfc {
    @SerializedName(value="ApplySuperscript")
    protected Boolean applySuperscript = null;
    @SerializedName(value="IsMatchCase")
    protected Boolean isMatchCase = null;
    @SerializedName(value="IsMatchWholeWord")
    protected Boolean isMatchWholeWord = null;
    @SerializedName(value="IsOldValueRegex")
    protected Boolean isOldValueRegex = null;
    @SerializedName(value="NewValue")
    protected String newValue = null;
    @SerializedName(value="OldValue")
    protected String oldValue = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether apply superscript to font or not.")
    public Boolean getApplySuperscript() {
        return this.applySuperscript;
    }

    public ReplaceTextParameters applySuperscript(Boolean applySuperscript) {
        this.applySuperscript = applySuperscript;
        return this;
    }

    public void setApplySuperscript(Boolean applySuperscript) {
        this.applySuperscript = applySuperscript;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether flag, true means the search is case-sensitive; false means the search is not case-sensitive.")
    public Boolean getIsMatchCase() {
        return this.isMatchCase;
    }

    public ReplaceTextParameters isMatchCase(Boolean isMatchCase) {
        this.isMatchCase = isMatchCase;
        return this;
    }

    public void setIsMatchCase(Boolean isMatchCase) {
        this.isMatchCase = isMatchCase;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether flag, means that only whole word matched are replaced.")
    public Boolean getIsMatchWholeWord() {
        return this.isMatchWholeWord;
    }

    public ReplaceTextParameters isMatchWholeWord(Boolean isMatchWholeWord) {
        this.isMatchWholeWord = isMatchWholeWord;
        return this;
    }

    public void setIsMatchWholeWord(Boolean isMatchWholeWord) {
        this.isMatchWholeWord = isMatchWholeWord;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether flag, means that OldValue contains regex expression.")
    public Boolean getIsOldValueRegex() {
        return this.isOldValueRegex;
    }

    public ReplaceTextParameters isOldValueRegex(Boolean isOldValueRegex) {
        this.isOldValueRegex = isOldValueRegex;
        return this;
    }

    public void setIsOldValueRegex(Boolean isOldValueRegex) {
        this.isOldValueRegex = isOldValueRegex;
    }

    @ApiModelProperty(value="Gets or sets the new text value to replace by.")
    public String getNewValue() {
        return this.newValue;
    }

    public ReplaceTextParameters newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @ApiModelProperty(value="Gets or sets the old text value (or regex pattern IsOldValueRegex) to replace.")
    public String getOldValue() {
        return this.oldValue;
    }

    public ReplaceTextParameters oldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.isMatchCase == null) {
            throw new ApiException(400, "Property IsMatchCase in ReplaceTextParameters is required.");
        }
        if (this.isMatchWholeWord == null) {
            throw new ApiException(400, "Property IsMatchWholeWord in ReplaceTextParameters is required.");
        }
        if (this.isOldValueRegex == null) {
            throw new ApiException(400, "Property IsOldValueRegex in ReplaceTextParameters is required.");
        }
        if (this.newValue == null) {
            throw new ApiException(400, "Property NewValue in ReplaceTextParameters is required.");
        }
        if (this.oldValue == null) {
            throw new ApiException(400, "Property OldValue in ReplaceTextParameters is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceTextParameters replaceTextParameters = (ReplaceTextParameters)o;
        return Objects.equals(this.applySuperscript, replaceTextParameters.applySuperscript) && Objects.equals(this.isMatchCase, replaceTextParameters.isMatchCase) && Objects.equals(this.isMatchWholeWord, replaceTextParameters.isMatchWholeWord) && Objects.equals(this.isOldValueRegex, replaceTextParameters.isOldValueRegex) && Objects.equals(this.newValue, replaceTextParameters.newValue) && Objects.equals(this.oldValue, replaceTextParameters.oldValue);
    }

    public int hashCode() {
        return Objects.hash(this.applySuperscript, this.isMatchCase, this.isMatchWholeWord, this.isOldValueRegex, this.newValue, this.oldValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceTextParameters {\n");
        sb.append("    applySuperscript: ").append(this.toIndentedString(this.getApplySuperscript())).append("\n");
        sb.append("    isMatchCase: ").append(this.toIndentedString(this.getIsMatchCase())).append("\n");
        sb.append("    isMatchWholeWord: ").append(this.toIndentedString(this.getIsMatchWholeWord())).append("\n");
        sb.append("    isOldValueRegex: ").append(this.toIndentedString(this.getIsOldValueRegex())).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.getNewValue())).append("\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.getOldValue())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

