/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.CsvDataLoadOptions;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.JsonDataLoadOptions;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.ReportBuildOptions;
import com.aspose.words.cloud.model.XmlDataLoadOptions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Report engine settings.")
public class ReportEngineSettings
implements ModelIfc {
    @SerializedName(value="CsvDataLoadOptions")
    protected CsvDataLoadOptions csvDataLoadOptions = null;
    @SerializedName(value="DataSourceName")
    protected String dataSourceName = null;
    @SerializedName(value="DataSourceType")
    protected DataSourceTypeEnum dataSourceType = null;
    @SerializedName(value="JsonDataLoadOptions")
    protected JsonDataLoadOptions jsonDataLoadOptions = null;
    @SerializedName(value="ReportBuildOptions")
    protected List<ReportBuildOptions> reportBuildOptions = null;
    @SerializedName(value="XmlDataLoadOptions")
    protected XmlDataLoadOptions xmlDataLoadOptions = null;

    @ApiModelProperty(value="Gets or sets the options for parsing CSV data.")
    public CsvDataLoadOptions getCsvDataLoadOptions() {
        return this.csvDataLoadOptions;
    }

    public ReportEngineSettings csvDataLoadOptions(CsvDataLoadOptions csvDataLoadOptions) {
        this.csvDataLoadOptions = csvDataLoadOptions;
        return this;
    }

    public void setCsvDataLoadOptions(CsvDataLoadOptions csvDataLoadOptions) {
        this.csvDataLoadOptions = csvDataLoadOptions;
    }

    @ApiModelProperty(value="Gets or sets the name to reference the data source object in the template.")
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public ReportEngineSettings dataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @ApiModelProperty(value="Gets or sets type of datasource.")
    public DataSourceTypeEnum getDataSourceType() {
        return this.dataSourceType;
    }

    public ReportEngineSettings dataSourceType(DataSourceTypeEnum dataSourceType) {
        this.dataSourceType = dataSourceType;
        return this;
    }

    public void setDataSourceType(DataSourceTypeEnum dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    @ApiModelProperty(value="Gets or sets the options for parsing JSON data.")
    public JsonDataLoadOptions getJsonDataLoadOptions() {
        return this.jsonDataLoadOptions;
    }

    public ReportEngineSettings jsonDataLoadOptions(JsonDataLoadOptions jsonDataLoadOptions) {
        this.jsonDataLoadOptions = jsonDataLoadOptions;
        return this;
    }

    public void setJsonDataLoadOptions(JsonDataLoadOptions jsonDataLoadOptions) {
        this.jsonDataLoadOptions = jsonDataLoadOptions;
    }

    @ApiModelProperty(value="Gets or sets type of options to build report.")
    public List<ReportBuildOptions> getReportBuildOptions() {
        return this.reportBuildOptions;
    }

    public ReportEngineSettings reportBuildOptions(List<ReportBuildOptions> reportBuildOptions) {
        this.reportBuildOptions = reportBuildOptions;
        return this;
    }

    public ReportEngineSettings addReportBuildOptionsItem(ReportBuildOptions reportBuildOptionsItem) {
        if (this.reportBuildOptions == null) {
            this.reportBuildOptions = new ArrayList<ReportBuildOptions>();
        }
        this.reportBuildOptions.add(reportBuildOptionsItem);
        return this;
    }

    public void setReportBuildOptions(List<ReportBuildOptions> reportBuildOptions) {
        this.reportBuildOptions = reportBuildOptions;
    }

    @ApiModelProperty(value="Gets or sets the options for parsing XML data.")
    public XmlDataLoadOptions getXmlDataLoadOptions() {
        return this.xmlDataLoadOptions;
    }

    public ReportEngineSettings xmlDataLoadOptions(XmlDataLoadOptions xmlDataLoadOptions) {
        this.xmlDataLoadOptions = xmlDataLoadOptions;
        return this;
    }

    public void setXmlDataLoadOptions(XmlDataLoadOptions xmlDataLoadOptions) {
        this.xmlDataLoadOptions = xmlDataLoadOptions;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.dataSourceType == null) {
            throw new ApiException(400, "Property DataSourceType in ReportEngineSettings is required.");
        }
        if (this.csvDataLoadOptions != null) {
            this.csvDataLoadOptions.validate();
        }
        if (this.jsonDataLoadOptions != null) {
            this.jsonDataLoadOptions.validate();
        }
        if (this.xmlDataLoadOptions != null) {
            this.xmlDataLoadOptions.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportEngineSettings reportEngineSettings = (ReportEngineSettings)o;
        return Objects.equals(this.csvDataLoadOptions, reportEngineSettings.csvDataLoadOptions) && Objects.equals(this.dataSourceName, reportEngineSettings.dataSourceName) && Objects.equals((Object)this.dataSourceType, (Object)reportEngineSettings.dataSourceType) && Objects.equals(this.jsonDataLoadOptions, reportEngineSettings.jsonDataLoadOptions) && Objects.equals(this.reportBuildOptions, reportEngineSettings.reportBuildOptions) && Objects.equals(this.xmlDataLoadOptions, reportEngineSettings.xmlDataLoadOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.csvDataLoadOptions, this.dataSourceName, this.dataSourceType, this.jsonDataLoadOptions, this.reportBuildOptions, this.xmlDataLoadOptions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportEngineSettings {\n");
        sb.append("    csvDataLoadOptions: ").append(this.toIndentedString(this.getCsvDataLoadOptions())).append("\n");
        sb.append("    dataSourceName: ").append(this.toIndentedString(this.getDataSourceName())).append("\n");
        sb.append("    dataSourceType: ").append(this.toIndentedString((Object)this.getDataSourceType())).append("\n");
        sb.append("    jsonDataLoadOptions: ").append(this.toIndentedString(this.getJsonDataLoadOptions())).append("\n");
        sb.append("    reportBuildOptions: ").append(this.toIndentedString(this.getReportBuildOptions())).append("\n");
        sb.append("    xmlDataLoadOptions: ").append(this.toIndentedString(this.getXmlDataLoadOptions())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DataSourceTypeEnum {
        XML("Xml"),
        JSON("Json"),
        CSV("Csv");

        private String value;

        private DataSourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DataSourceTypeEnum fromValue(String text) {
            for (DataSourceTypeEnum b : DataSourceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DataSourceTypeEnum> {
            public void write(JsonWriter jsonWriter, DataSourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DataSourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DataSourceTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

