/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.TimeZoneInfoData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="base container class for save options data.")
public abstract class SaveOptionsData
implements ModelIfc {
    @SerializedName(value="AllowEmbeddingPostScriptFonts")
    protected Boolean allowEmbeddingPostScriptFonts = null;
    @SerializedName(value="CustomTimeZoneInfoData")
    protected TimeZoneInfoData customTimeZoneInfoData = null;
    @SerializedName(value="Dml3DEffectsRenderingMode")
    protected Dml3DEffectsRenderingModeEnum dml3DEffectsRenderingMode = null;
    @SerializedName(value="DmlEffectsRenderingMode")
    protected DmlEffectsRenderingModeEnum dmlEffectsRenderingMode = null;
    @SerializedName(value="DmlRenderingMode")
    protected DmlRenderingModeEnum dmlRenderingMode = null;
    @SerializedName(value="FileName")
    protected String fileName = null;
    @SerializedName(value="ImlRenderingMode")
    protected ImlRenderingModeEnum imlRenderingMode = null;
    @SerializedName(value="UpdateAmbiguousTextFont")
    protected Boolean updateAmbiguousTextFont = null;
    @SerializedName(value="UpdateCreatedTimeProperty")
    protected Boolean updateCreatedTimeProperty = null;
    @SerializedName(value="UpdateFields")
    protected Boolean updateFields = null;
    @SerializedName(value="UpdateLastPrintedProperty")
    protected Boolean updateLastPrintedProperty = null;
    @SerializedName(value="UpdateLastSavedTimeProperty")
    protected Boolean updateLastSavedTimeProperty = null;
    @SerializedName(value="ZipOutput")
    protected Boolean zipOutput = null;
    @SerializedName(value="SaveFormat")
    protected String saveFormat = null;

    @ApiModelProperty(value="Gets or sets a boolean value indicating whether to allow embedding fonts with PostScript outlines when embedding TrueType fonts in a document upon it is saved. The default value is false.. Note, Word does not embed PostScript fonts, but can open documents with embedded fonts of this type. This option only works when Aspose.Words.Fonts.FontInfoCollection.EmbedTrueTypeFonts of the Aspose.Words.DocumentBase.FontInfos property is set to true. The default value is false.")
    public Boolean getAllowEmbeddingPostScriptFonts() {
        return this.allowEmbeddingPostScriptFonts;
    }

    public SaveOptionsData allowEmbeddingPostScriptFonts(Boolean allowEmbeddingPostScriptFonts) {
        this.allowEmbeddingPostScriptFonts = allowEmbeddingPostScriptFonts;
        return this;
    }

    public void setAllowEmbeddingPostScriptFonts(Boolean allowEmbeddingPostScriptFonts) {
        this.allowEmbeddingPostScriptFonts = allowEmbeddingPostScriptFonts;
    }

    @ApiModelProperty(value="Gets or sets CustomTimeZoneInfo.")
    public TimeZoneInfoData getCustomTimeZoneInfoData() {
        return this.customTimeZoneInfoData;
    }

    public SaveOptionsData customTimeZoneInfoData(TimeZoneInfoData customTimeZoneInfoData) {
        this.customTimeZoneInfoData = customTimeZoneInfoData;
        return this;
    }

    public void setCustomTimeZoneInfoData(TimeZoneInfoData customTimeZoneInfoData) {
        this.customTimeZoneInfoData = customTimeZoneInfoData;
    }

    @ApiModelProperty(value="Gets or sets the value determining how 3D effects are rendered. The default value is Aspose.Words.Saving.Dml3DEffectsRenderingMode.Basic.")
    public Dml3DEffectsRenderingModeEnum getDml3DEffectsRenderingMode() {
        return this.dml3DEffectsRenderingMode;
    }

    public SaveOptionsData dml3DEffectsRenderingMode(Dml3DEffectsRenderingModeEnum dml3DEffectsRenderingMode) {
        this.dml3DEffectsRenderingMode = dml3DEffectsRenderingMode;
        return this;
    }

    public void setDml3DEffectsRenderingMode(Dml3DEffectsRenderingModeEnum dml3DEffectsRenderingMode) {
        this.dml3DEffectsRenderingMode = dml3DEffectsRenderingMode;
    }

    @ApiModelProperty(value="Gets or sets the value determining how DrawingML effects are rendered. { Simplified | None | Fine }. The default value is Simplified. This property is used when the document is exported to fixed page formats.")
    public DmlEffectsRenderingModeEnum getDmlEffectsRenderingMode() {
        return this.dmlEffectsRenderingMode;
    }

    public SaveOptionsData dmlEffectsRenderingMode(DmlEffectsRenderingModeEnum dmlEffectsRenderingMode) {
        this.dmlEffectsRenderingMode = dmlEffectsRenderingMode;
        return this;
    }

    public void setDmlEffectsRenderingMode(DmlEffectsRenderingModeEnum dmlEffectsRenderingMode) {
        this.dmlEffectsRenderingMode = dmlEffectsRenderingMode;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how DrawingML shapes are rendered. { Fallback | DrawingML }. The default value is Fallback. This property is used when the document is exported to fixed page formats.")
    public DmlRenderingModeEnum getDmlRenderingMode() {
        return this.dmlRenderingMode;
    }

    public SaveOptionsData dmlRenderingMode(DmlRenderingModeEnum dmlRenderingMode) {
        this.dmlRenderingMode = dmlRenderingMode;
        return this;
    }

    public void setDmlRenderingMode(DmlRenderingModeEnum dmlRenderingMode) {
        this.dmlRenderingMode = dmlRenderingMode;
    }

    @ApiModelProperty(value="Gets or sets the name of destination file.")
    public String getFileName() {
        return this.fileName;
    }

    public SaveOptionsData fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ApiModelProperty(value="Gets or sets the value determining how ink (InkML) objects are rendered. The default value is Aspose.Words.Saving.ImlRenderingMode.InkML.")
    public ImlRenderingModeEnum getImlRenderingMode() {
        return this.imlRenderingMode;
    }

    public SaveOptionsData imlRenderingMode(ImlRenderingModeEnum imlRenderingMode) {
        this.imlRenderingMode = imlRenderingMode;
        return this;
    }

    public void setImlRenderingMode(ImlRenderingModeEnum imlRenderingMode) {
        this.imlRenderingMode = imlRenderingMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the font attributes will be changed according to the character code being used.")
    public Boolean getUpdateAmbiguousTextFont() {
        return this.updateAmbiguousTextFont;
    }

    public SaveOptionsData updateAmbiguousTextFont(Boolean updateAmbiguousTextFont) {
        this.updateAmbiguousTextFont = updateAmbiguousTextFont;
        return this;
    }

    public void setUpdateAmbiguousTextFont(Boolean updateAmbiguousTextFont) {
        this.updateAmbiguousTextFont = updateAmbiguousTextFont;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether the Aspose.Words.Properties.BuiltInDocumentProperties.CreatedTime property is updated before saving. The default value is false.")
    public Boolean getUpdateCreatedTimeProperty() {
        return this.updateCreatedTimeProperty;
    }

    public SaveOptionsData updateCreatedTimeProperty(Boolean updateCreatedTimeProperty) {
        this.updateCreatedTimeProperty = updateCreatedTimeProperty;
        return this;
    }

    public void setUpdateCreatedTimeProperty(Boolean updateCreatedTimeProperty) {
        this.updateCreatedTimeProperty = updateCreatedTimeProperty;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fields should be updated before saving the document to a fixed page format. The default value is true.")
    public Boolean getUpdateFields() {
        return this.updateFields;
    }

    public SaveOptionsData updateFields(Boolean updateFields) {
        this.updateFields = updateFields;
        return this;
    }

    public void setUpdateFields(Boolean updateFields) {
        this.updateFields = updateFields;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the Aspose.Words.Properties.BuiltInDocumentProperties.LastPrinted property is updated before saving.")
    public Boolean getUpdateLastPrintedProperty() {
        return this.updateLastPrintedProperty;
    }

    public SaveOptionsData updateLastPrintedProperty(Boolean updateLastPrintedProperty) {
        this.updateLastPrintedProperty = updateLastPrintedProperty;
        return this;
    }

    public void setUpdateLastPrintedProperty(Boolean updateLastPrintedProperty) {
        this.updateLastPrintedProperty = updateLastPrintedProperty;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the Aspose.Words.Properties.BuiltInDocumentProperties.LastSavedTime property is updated before saving. The default value is false.")
    public Boolean getUpdateLastSavedTimeProperty() {
        return this.updateLastSavedTimeProperty;
    }

    public SaveOptionsData updateLastSavedTimeProperty(Boolean updateLastSavedTimeProperty) {
        this.updateLastSavedTimeProperty = updateLastSavedTimeProperty;
        return this;
    }

    public void setUpdateLastSavedTimeProperty(Boolean updateLastSavedTimeProperty) {
        this.updateLastSavedTimeProperty = updateLastSavedTimeProperty;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to zip output or not. The default value is false. When set to true, output files will be zipped.")
    public Boolean getZipOutput() {
        return this.zipOutput;
    }

    public SaveOptionsData zipOutput(Boolean zipOutput) {
        this.zipOutput = zipOutput;
        return this;
    }

    public void setZipOutput(Boolean zipOutput) {
        this.zipOutput = zipOutput;
    }

    @ApiModelProperty(value="Gets the format of save.")
    public String getSaveFormat() {
        return this.saveFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.fileName == null) {
            throw new ApiException(400, "Property FileName in SaveOptionsData is required.");
        }
        if (this.customTimeZoneInfoData != null) {
            this.customTimeZoneInfoData.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SaveOptionsData saveOptionsData = (SaveOptionsData)o;
        return Objects.equals(this.allowEmbeddingPostScriptFonts, saveOptionsData.allowEmbeddingPostScriptFonts) && Objects.equals(this.customTimeZoneInfoData, saveOptionsData.customTimeZoneInfoData) && Objects.equals((Object)this.dml3DEffectsRenderingMode, (Object)saveOptionsData.dml3DEffectsRenderingMode) && Objects.equals((Object)this.dmlEffectsRenderingMode, (Object)saveOptionsData.dmlEffectsRenderingMode) && Objects.equals((Object)this.dmlRenderingMode, (Object)saveOptionsData.dmlRenderingMode) && Objects.equals(this.fileName, saveOptionsData.fileName) && Objects.equals((Object)this.imlRenderingMode, (Object)saveOptionsData.imlRenderingMode) && Objects.equals(this.updateAmbiguousTextFont, saveOptionsData.updateAmbiguousTextFont) && Objects.equals(this.updateCreatedTimeProperty, saveOptionsData.updateCreatedTimeProperty) && Objects.equals(this.updateFields, saveOptionsData.updateFields) && Objects.equals(this.updateLastPrintedProperty, saveOptionsData.updateLastPrintedProperty) && Objects.equals(this.updateLastSavedTimeProperty, saveOptionsData.updateLastSavedTimeProperty) && Objects.equals(this.zipOutput, saveOptionsData.zipOutput) && Objects.equals(this.saveFormat, saveOptionsData.saveFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowEmbeddingPostScriptFonts, this.customTimeZoneInfoData, this.dml3DEffectsRenderingMode, this.dmlEffectsRenderingMode, this.dmlRenderingMode, this.fileName, this.imlRenderingMode, this.updateAmbiguousTextFont, this.updateCreatedTimeProperty, this.updateFields, this.updateLastPrintedProperty, this.updateLastSavedTimeProperty, this.zipOutput, this.saveFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum Dml3DEffectsRenderingModeEnum {
        BASIC("Basic"),
        ADVANCED("Advanced");

        private String value;

        private Dml3DEffectsRenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static Dml3DEffectsRenderingModeEnum fromValue(String text) {
            for (Dml3DEffectsRenderingModeEnum b : Dml3DEffectsRenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<Dml3DEffectsRenderingModeEnum> {
            public void write(JsonWriter jsonWriter, Dml3DEffectsRenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public Dml3DEffectsRenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return Dml3DEffectsRenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DmlEffectsRenderingModeEnum {
        SIMPLIFIED("Simplified"),
        NONE("None"),
        FINE("Fine");

        private String value;

        private DmlEffectsRenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DmlEffectsRenderingModeEnum fromValue(String text) {
            for (DmlEffectsRenderingModeEnum b : DmlEffectsRenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DmlEffectsRenderingModeEnum> {
            public void write(JsonWriter jsonWriter, DmlEffectsRenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DmlEffectsRenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DmlEffectsRenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DmlRenderingModeEnum {
        FALLBACK("Fallback"),
        DRAWINGML("DrawingML");

        private String value;

        private DmlRenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DmlRenderingModeEnum fromValue(String text) {
            for (DmlRenderingModeEnum b : DmlRenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DmlRenderingModeEnum> {
            public void write(JsonWriter jsonWriter, DmlRenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DmlRenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DmlRenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImlRenderingModeEnum {
        FALLBACK("Fallback"),
        INKML("InkML");

        private String value;

        private ImlRenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImlRenderingModeEnum fromValue(String text) {
            for (ImlRenderingModeEnum b : ImlRenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImlRenderingModeEnum> {
            public void write(JsonWriter jsonWriter, ImlRenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImlRenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImlRenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

