/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SearchResultsCollection;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with a regular expression pattern and a collection of search results. This response is returned by the Service when handling \"GET https://api.aspose.cloud/v4.0/words/Test.doc/search\" REST API requests.")
public class SearchResponse
extends WordsResponse {
    @SerializedName(value="SearchingPattern")
    protected String searchingPattern = null;
    @SerializedName(value="SearchResults")
    protected SearchResultsCollection searchResults = null;

    @ApiModelProperty(value="Gets or sets the regular expression pattern used to find matches.")
    public String getSearchingPattern() {
        return this.searchingPattern;
    }

    public SearchResponse searchingPattern(String searchingPattern) {
        this.searchingPattern = searchingPattern;
        return this;
    }

    public void setSearchingPattern(String searchingPattern) {
        this.searchingPattern = searchingPattern;
    }

    @ApiModelProperty(value="Gets or sets the collection of search results.")
    public SearchResultsCollection getSearchResults() {
        return this.searchResults;
    }

    public SearchResponse searchResults(SearchResultsCollection searchResults) {
        this.searchResults = searchResults;
        return this;
    }

    public void setSearchResults(SearchResultsCollection searchResults) {
        this.searchResults = searchResults;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.searchResults != null) {
            this.searchResults.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResponse searchResponse = (SearchResponse)o;
        return Objects.equals(this.searchingPattern, searchResponse.searchingPattern) && Objects.equals(this.searchResults, searchResponse.searchResults) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.searchingPattern, this.searchResults, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    searchingPattern: ").append(this.toIndentedString(this.getSearchingPattern())).append("\n");
        sb.append("    searchResults: ").append(this.toIndentedString(this.getSearchResults())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

