/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.NodeLink;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a section element.")
public class Section
extends LinkElement {
    @SerializedName(value="ChildNodes")
    protected List<NodeLink> childNodes = null;
    @SerializedName(value="Paragraphs")
    protected LinkElement paragraphs = null;
    @SerializedName(value="PageSetup")
    protected LinkElement pageSetup = null;
    @SerializedName(value="HeaderFooters")
    protected LinkElement headerFooters = null;
    @SerializedName(value="Tables")
    protected LinkElement tables = null;

    @ApiModelProperty(value="Gets or sets the list of child nodes.")
    public List<NodeLink> getChildNodes() {
        return this.childNodes;
    }

    public Section childNodes(List<NodeLink> childNodes) {
        this.childNodes = childNodes;
        return this;
    }

    public Section addChildNodesItem(NodeLink childNodesItem) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<NodeLink>();
        }
        this.childNodes.add(childNodesItem);
        return this;
    }

    public void setChildNodes(List<NodeLink> childNodes) {
        this.childNodes = childNodes;
    }

    @ApiModelProperty(value="Gets or sets the link to Paragraphs resource.")
    public LinkElement getParagraphs() {
        return this.paragraphs;
    }

    public Section paragraphs(LinkElement paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public void setParagraphs(LinkElement paragraphs) {
        this.paragraphs = paragraphs;
    }

    @ApiModelProperty(value="Gets or sets the link to PageSetup resource.")
    public LinkElement getPageSetup() {
        return this.pageSetup;
    }

    public Section pageSetup(LinkElement pageSetup) {
        this.pageSetup = pageSetup;
        return this;
    }

    public void setPageSetup(LinkElement pageSetup) {
        this.pageSetup = pageSetup;
    }

    @ApiModelProperty(value="Gets or sets the link to HeaderFooters resource.")
    public LinkElement getHeaderFooters() {
        return this.headerFooters;
    }

    public Section headerFooters(LinkElement headerFooters) {
        this.headerFooters = headerFooters;
        return this;
    }

    public void setHeaderFooters(LinkElement headerFooters) {
        this.headerFooters = headerFooters;
    }

    @ApiModelProperty(value="Gets or sets the link to Tables resource.")
    public LinkElement getTables() {
        return this.tables;
    }

    public Section tables(LinkElement tables) {
        this.tables = tables;
        return this;
    }

    public void setTables(LinkElement tables) {
        this.tables = tables;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.childNodes != null) {
            for (ModelIfc modelIfc : this.childNodes) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.paragraphs != null) {
            this.paragraphs.validate();
        }
        if (this.pageSetup != null) {
            this.pageSetup.validate();
        }
        if (this.headerFooters != null) {
            this.headerFooters.validate();
        }
        if (this.tables != null) {
            this.tables.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Section section = (Section)o;
        return Objects.equals(this.childNodes, section.childNodes) && Objects.equals(this.paragraphs, section.paragraphs) && Objects.equals(this.pageSetup, section.pageSetup) && Objects.equals(this.headerFooters, section.headerFooters) && Objects.equals(this.tables, section.tables) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childNodes, this.paragraphs, this.pageSetup, this.headerFooters, this.tables, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Section {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    childNodes: ").append(this.toIndentedString(this.getChildNodes())).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.getParagraphs())).append("\n");
        sb.append("    pageSetup: ").append(this.toIndentedString(this.getPageSetup())).append("\n");
        sb.append("    headerFooters: ").append(this.toIndentedString(this.getHeaderFooters())).append("\n");
        sb.append("    tables: ").append(this.toIndentedString(this.getTables())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

